/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
***************************************************************************

*/

#ifndef DEDICATED

void se_FetchAndStoreSDLInput();

#include "tEventQueue.h"
#include "eTess.h"
#include "rTexture.h"
#include "eGameObject.h"
#include "rFont.h"
#include "eTimer.h"
#include "eCamera.h"
#include "rScreen.h"
#include "tConfiguration.h"
#include "rRender.h"
#include "eWall.h"
#include "eAdvWall.h"
#include "eFloor.h"

#define eWall_h 4
#define view_h 2.7

#ifdef DEBUG
bool debug_grid=1;
#endif

REAL upper_height=100;
REAL lower_height=50;

// floor mirror
static REAL sr_floorMirror_strength=.1;
static tSettingItem<REAL> f_m("FLOOR_MIRROR_INT","Intensity of the floor mirror effect",sr_floorMirror_strength);


#ifndef DEDICATED

static rTexture sky(rTEX_FLOOR,"textures/sky.png",1,1,true);

static void infinity_xy_plane(const eCoord &pos,const eCoord &dir,REAL h=0){
  glEdgeFlag(GL_FALSE);

  bool use_rim=false;
  REAL zero=0;
  
  if (sr_highRim)
    use_rim=true;

  if (use_rim){
    BeginTriangles();
    for(int i=se_rimWalls.Len()-1;i>=0;i--){
      eCoord p1=se_rimWalls(i)->EndPoint(0);
      eCoord p2=se_rimWalls(i)->EndPoint(1);

      glTexCoord2f(pos.x, pos.y);
      glVertex3f  (pos.x, pos.y, h);

      glTexCoord2f(p1.x, p1.y);
      glVertex3f  (p1.x, p1.y, h);

      glTexCoord2f(p2.x, p2.y);
      glVertex3f  (p2.x, p2.y, h);
    }
    RenderEnd();
  }
  else{
    if (!sr_infinityPlane)
      zero=.000001;

    BeginTriangleFan();

    glTexCoord4f(pos.x-dir.x, pos.y-dir.y, h, 1);
    glVertex4f  (pos.x-dir.x, pos.y-dir.y, h, 1);
    
    glTexCoord4f(1,0.1,zero*h,zero);
    glVertex4f  (1,0.1,zero*h,zero);

    glTexCoord4f(0.1,1.1,zero*h,zero);
    glVertex4f  (0.1,1.1,zero*h,zero);

    glTexCoord4f(-1,0.1,zero*h,zero);
    glVertex4f  (-1,0.1,zero*h,zero);

    glTexCoord4f(0.1,-1.1,zero*h,zero);
    glVertex4f  (0.1,-1.1,zero*h,zero);

    glTexCoord4f(1,0.1,zero*h,zero);
    glVertex4f  (1,0.1,zero*h,zero);

    RenderEnd();
  }
}

static REAL z=0;


eWall *displayed_eWall=0;

void draw_eWall(int v,int i){
	if (i<se_wallsVisible[v].Len()){
    eWallView *view=se_wallsVisible[v](i);
#ifdef DEBUG
    if (view->Value()<=z){
#endif

      displayed_eWall = view->Belongs();
      if (displayed_eWall->Edge()->len > .01) displayed_eWall->Render();
      displayed_eWall=0;

      draw_eWall(v,tHeapBase::UpperL(i));
      draw_eWall(v,tHeapBase::UpperR(i));

#ifdef DEBUG
    }
#endif 

  }

}


void paint_sr_lowerSky(int viewer,bool sr_upperSky){
  TexMatrix();
  glLoadIdentity();
  glScalef(.005,.005,.005);
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_CULL_FACE);
	
  if (sr_skyWobble){
    glTranslatef(se_GameTime()*.1,se_GameTime()*.07145,0);
    glScalef(1+.2*sin(se_GameTime()),1+.1*cos(se_GameTime()),1);
    glTranslatef(-300,-200,0);
  }

  sky.Select();
  
  REAL sa=(lower_height-z)*.1;
  if (sa>1) sa=1;
  if (!sr_upperSky){
    sa=1;
    glBlendFunc(GL_SRC_ALPHA,GL_ZERO);
  }
  if (sa>0){    
    glColor4f(1,1,1,sa);
    infinity_xy_plane(CameraPos(viewer),CameraDir(viewer),lower_height);
  }
  if (!sr_upperSky && sr_alphaBlend)
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
}

static void display_simple(int viewer,bool floor,
			   bool sr_upperSky,bool sr_lowerSky,
			   REAL flooralpha,
			   bool eWalls,bool gameObjects){
  /*
  static GLfloat S[]={1,0,0,0};
  static GLfloat T[]={0,1,0,0};
  static GLfloat R[]={0,0,1,0};
  static GLfloat Q[]={0,0,0,1};
  
  glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGenfv(GL_S,GL_OBJECT_PLANE,S);
  
  glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGenfv(GL_T,GL_OBJECT_PLANE,T);
  
  glTexGeni(GL_R,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGenfv(GL_R,GL_OBJECT_PLANE,R);
  
  glTexGeni(GL_Q,GL_TEXTURE_GEN_MODE,GL_OBJECT_LINEAR);
  glTexGenfv(GL_Q,GL_OBJECT_PLANE,Q);
  
  glDisable(GL_TEXTURE_GEN_T);
  glDisable(GL_TEXTURE_GEN_S);
  glDisable(GL_TEXTURE_GEN_R);
  glDisable(GL_TEXTURE_GEN_Q);
  */
  
      
  glEdgeFlag(GL_FALSE);

  glDisable(GL_DEPTH_TEST);

  glDisable(GL_CULL_FACE);

  if (sr_upperSky || blacksky()){
    if (blacksky()){
      //glDisable(GL_TEXTURE);
      glDisable(GL_TEXTURE_2D);

      glColor3f(0,0,0);
      
      infinity_xy_plane(CameraPos(viewer),CameraDir(viewer),lower_height);

      glEnable(GL_TEXTURE_2D);
    }
    else {
      TexMatrix();
      glLoadIdentity();
      glScalef(.25,.25,.25);
      
      glfloortexture();
      
      glColor3f(.5,.5,1);
      
      infinity_xy_plane(CameraPos(viewer),CameraDir(viewer),upper_height);
    }
  }

  if (sr_lowerSky && !sr_highRim){
    paint_sr_lowerSky(viewer,sr_upperSky);
  }

  if (floor){
    se_FetchAndStoreSDLInput();
    switch(sr_floorDetail){
    case rFLOOR_OFF:
      break;
    case rFLOOR_GRID:
      {
	#define SIDELEN   (4*gridSize())
	#define EXTENSION 10

	REAL x=CameraPos(viewer).x;
	REAL y=CameraPos(viewer).y;
	int xn=(int)(x/SIDELEN);
	int yn=(int)(y/SIDELEN);
	

	//glDisable(GL_TEXTURE);
	glDisable(GL_TEXTURE_2D);

	#define INTENSITY(x,xx) (1-(((x)-(xx))*((x)-(xx))/(EXTENSION*SIDELEN*EXTENSION*SIDELEN)))


	BeginLines();
	for(int i=xn-EXTENSION;i<=xn+EXTENSION;i++){
	  REAL intens=INTENSITY(i*SIDELEN,x);
	  if (intens<0) intens=0;
	  glfloorcolor(intens,intens);
	  glVertex2f(i*SIDELEN,y-SIDELEN*(EXTENSION+1));
	  glVertex2f(i*SIDELEN,y+SIDELEN*(EXTENSION+1));
	}
	for(int j=yn-EXTENSION;j<=yn+EXTENSION;j++){
	  REAL intens=INTENSITY(j*SIDELEN,y);
	  if (intens<0) intens=0;
	  glfloorcolor(intens,intens);
	  glVertex2f(x-(EXTENSION+1)*SIDELEN,j*SIDELEN);
	  glVertex2f(x+(EXTENSION+1)*SIDELEN,j*SIDELEN);
	}
	RenderEnd();
      }
      break;

    case rFLOOR_TEXTURE:
      TexMatrix();
      glLoadIdentity();
      glScalef(.25/gridSize(),.25/gridSize(),.25/gridSize());
      
      glfloortexture();
      glfloorcolor(flooralpha);
      
      infinity_xy_plane(CameraPos(viewer),CameraDir(viewer));
      
      /* old way: draw every triangle
      for(int i=eFace::faces.Len()-1;i>=0;i--){
	eFace *f=eFace::faces(i);

	if (f->visHeight[viewer]<z){
	  glBegin(GL_TRIANGLES);
	  for(int j=0;j<=2;j++){
	    glVertex3f(f->p[j]->x,f->p[j]->y,0);
	  }
	  glEnd();
	}
      }
      */

      break;

    case rFLOOR_TWOTEXTURE:
      glfloorcolor(flooralpha);

      TexMatrix();
      glLoadIdentity();
      REAL gs = 1/gridSize();
      glScalef(0.01*gs,.25*gs,.25*gs);

      glfloortexture_a();
      infinity_xy_plane(CameraPos(viewer),CameraDir(viewer));

      glfloorcolor(flooralpha);

      TexMatrix();
      glLoadIdentity();
      glScalef(.25*gs,.01*gs,.25*gs);

      glfloortexture_b();

      glDepthFunc(GL_LEQUAL);
      glBlendFunc(GL_SRC_ALPHA,GL_ONE);
      infinity_xy_plane(CameraPos(viewer),CameraDir(viewer));
      glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
      
      break;
    }
  }

  TexMatrix();
  glLoadIdentity();
  ModelMatrix();

  //  glDisable(GL_TEXTURE_GEN_S);
  //  glDisable(GL_TEXTURE_GEN_T);
  //  glDisable(GL_TEXTURE_GEN_Q);
  //  glDisable(GL_TEXTURE_GEN_R);   




  if(eWalls){
    for(int i=se_rimWalls.Len()-1;i>=0;i--){
      se_FetchAndStoreSDLInput();
      se_rimWalls(i)->RenderReal();
    }

    if (sr_lowerSky && sr_highRim){
      //      glEnable(GL_TEXTURE_GEN_S);
      //      glEnable(GL_TEXTURE_GEN_T);
      //      glEnable(GL_TEXTURE_GEN_Q);
      //      glEnable(GL_TEXTURE_GEN_R);   

      paint_sr_lowerSky(viewer,sr_upperSky);

      //      glDisable(GL_TEXTURE_GEN_S);
      //      glDisable(GL_TEXTURE_GEN_T);
      //      glDisable(GL_TEXTURE_GEN_Q);
      //      glDisable(GL_TEXTURE_GEN_R);   
  
      TexMatrix();
      glLoadIdentity();
      ModelMatrix();
    }

    glEnable(GL_DEPTH_TEST);
  }
  else
    glEnable(GL_DEPTH_TEST);

  if (eWalls){
    glDisable(GL_CULL_FACE);
    draw_eWall(viewer,0);

    /*
#ifdef DEBUG
    for(int i=sg_netPlayerWalls.Len()-1;i>=0;i--){
      glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
      if (sg_netPlayerWalls(i)->Preliminary())
	glTranslatef(0,0,4);
      else
	glTranslatef(0,0,8);
      if (sg_netPlayerWalls(i)->Wall())
	sg_netPlayerWalls(i)->Wall()->RenderList(false);
      glPopMatrix();
      }
#endif
    */

    /*
    static int oldlen=0;
    int newlen=sg_netPlayerWalls.Len();
    if (newlen!=oldlen){
      con << "Number of player eWalls now " << newlen << '\n';
      oldlen=newlen;
    }
    */
    
  }

  if (gameObjects)
    eGameObject::RenderAll();
  

#ifdef DEBUG
  if (debug_grid){
    //glDisable(GL_TEXTURE);
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);
    BeginLines();

    int i;
    for(i=eEdge::edges.Len()-1;i>=0;i--){
      eEdge *e=eEdge::edges[i];
      if (e->f[1])
	glColor4f(1,1,1,1);
      else if (e->f[0])
	glColor4f(0,1,1,1);
      else
	glColor4f(0,0,1,1);

      glVertex3f(e->p[0]->x,e->p[0]->y,10);
      glVertex3f(e->p[0]->x,e->p[0]->y,15);
      glVertex3f(e->p[0]->x,e->p[0]->y,.3);
      glVertex3f(e->p[1]->x,e->p[1]->y,.3);
      glVertex3f(e->p[1]->x,e->p[1]->y,10);
      glVertex3f(e->p[1]->x,e->p[1]->y,15);

    }

    for(i=ePoint::points.Len()-1;i>=0;i--){
      ePoint *p=ePoint::points[i];
	glColor4f(1,0,0,1);
      glVertex3f(p->x,p->y,0);
      glVertex3f(p->x,p->y,(p->refCtr+1)*5);
    }
    /*
    for(int i=sg_netPlayerWalls.Len()-1;i>=0;i--){
      eEdge *e=sg_netPlayerWalls[i]->Edge();
	glColor4f(0,1,0,1);

      glVertex3f(e->p[0]->x,e->p[0]->y,5);
      glVertex3f(e->p[0]->x,e->p[0]->y,10);
      glVertex3f(e->p[0]->x,e->p[0]->y,10);
      glVertex3f(e->p[1]->x,e->p[1]->y,10);
      glVertex3f(e->p[1]->x,e->p[1]->y,10);
      glVertex3f(e->p[1]->x,e->p[1]->y,5);
    }
    */
    RenderEnd();
  }
#endif
    
}
#endif

void Render(int viewer){
  if (!sr_glOut)
    return;
#ifndef DEDICATED
  ProjMatrix();

  z=CameraHeight(viewer);

  if (sr_floorMirror){
    ModelMatrix();
    glScalef(1,1,-1);
    
    if (z>10) z=10;
    glFrontFace(GL_CW);

    bool us=false;
    bool ls=false;

    if (sr_floorMirror>=rMIRROR_ALL){
      us=sr_upperSky;
      ls=sr_lowerSky;
    }
    else if (sr_floorMirror>=rMIRROR_WALLS){
      if (sr_lowerSky)
	ls=true;
      else if (sr_upperSky)
	us=true;
    }

    display_simple(viewer,false,
		   us,ls,
		   0,
		   sr_floorMirror>=rMIRROR_WALLS,
		   sr_floorMirror>=rMIRROR_OBJECTS);
    z=CameraHeight(viewer);
    glFrontFace(GL_CCW);
    ModelMatrix();
    glScalef(1,1,-1);


    display_simple(viewer,true,
		   sr_upperSky,sr_lowerSky,
		   1-sr_floorMirror_strength,
		   true,true);
    
  }
  else
    display_simple(viewer,true,
		   sr_upperSky,sr_lowerSky,
		   1,
		   true,true);

  

#ifdef EVENT_DEB
  for(int i=eEdge_crossing.Len()-1;i>=0;i--){
    eEdge_crossing(i)->Render();
  }
#endif
#endif
}


void eEdgeViewer::Render(){}

void eViewerCrossesEdge::Render(){
#ifndef DEDICATED
  ePoint *p1=e->p[0];
  ePoint *p2=e->p[1];

  REAL timeLeft=value-se_GameTime();

  REAL h;

  if (viewer==1){
    if (timeLeft>0){
      h=timeLeft+4;
      glColor4f(0,0,1,.5);
    }
    else{
      h=-timeLeft+4;
      glColor4f(1,0,0,.5);
    }

    //  else
    //glColor4f(1,0,0,.5);

    static rTexture ArmageTron_invis_eWall(rTEX_WALL,"textures/eWall2.png",1,0);
    
    ArmageTron_invis_eWall.Select();
    
    eWall::Render_helper(e,(p1->x+p1->y)/4,(p2->x+p2->y)/4,h,1,4);
  }
#endif
}

#endif


