/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "eGameObject.h"
#include "uInputQueue.h"
#include "eTimer.h"
#include "eTess.h"
#include "eWall.h"
#include "tConsole.h"
#include "rScreen.h"
#include "eSound.h"
#include "eAdvWall.h"

List<eGameObject> eGameObject::gameObjects;
List<eGameObject> eGameObject::gameObjectsInactive;
List<eGameObject> eGameObject::gameObjectsInteresting;


  // entry and deletion in the list of all gameObjects
void eGameObject::AddToList(){
  se_SoundLock();
  gameObjectsInactive.Remove(this,inactiveID);
  gameObjects.Add(this,id);
  se_SoundUnlock();
}
void eGameObject::RemoveFromList(){
  se_SoundLock();
  
  currentFace = NULL;
  gameObjects.Remove(this,id);
  gameObjectsInactive.Add(this,inactiveID);
  se_SoundUnlock();
}

void eGameObject::RemoveFromListsAll(){
  se_SoundLock();

  currentFace = NULL;
  gameObjects.Remove(this,id);
  gameObjectsInactive.Remove(this,inactiveID);
  gameObjectsInteresting.Remove(this,interestingID);
  se_SoundUnlock();
}

void eGameObject::RemoveFromGame(){
  delete this;
}



eGameObject::eGameObject(const eCoord &p,const eCoord &d,bool autodel)
  :autodelete(autodel),pos(p),dir(d){
  currentFace=NULL;
  lastTime=se_GameTime();
  id=-1;
  interestingID=-1;
  inactiveID=-1;
  AddToList();
  FindCurrentFace();
  lastTime=0;
}

eGameObject::~eGameObject(){
  RemoveFromListsAll();
  tCHECK_DEST;
}

  // returns the type of this object (important for interaction of
  // two gameObjects)
//gameobject_type gameobject::type(){return ArmageTron_GENERIC;}

  // makes two gameObjects interact:
void eGameObject::InteractWith(eGameObject *,REAL,int){}

// what happens if we pass eWall w?
void eGameObject::PassEdge(const eEdge *e,REAL,REAL,int){
  if (e->Wall()) Kill();
}

// moves
void eGameObject::Move(const eCoord &dest,REAL startTime,REAL endTime){
#ifdef DEBUG
  se_CheckGrid();
#endif


  ePoint start(pos),stop(dest);

  eWallRim::Bound(stop,-10);
  //  se_GridRange(dest.Norm_squared());

  eEdge  e(&start,&stop);

  // check all the currently drawn eWalls:
  for(int i=se_wallsNotYetInserted.Len()-1;i>=0;i--){
    const eEdge *other_e=se_wallsNotYetInserted[i]->Edge();
    if (//!sg_netPlayerWalls(i)->Preliminary() &&
	e.p[0] && e.p[1] 
	&& other_e->p[0] && other_e->p[1]){
      ePoint *new_cross_p=e.IntersectWith(other_e);
      if (new_cross_p){
	REAL e_ratio =e.Ratio(*new_cross_p);
	REAL o_ratio =other_e->Ratio(*new_cross_p);
	if (0<=e_ratio && 1>=e_ratio &&
	    0<=o_ratio && 1>=o_ratio)
	  PassEdge(other_e,
		    startTime+(endTime-startTime)*e_ratio,
		    o_ratio,0);
	delete new_cross_p;
      }
    }
  }

  if (!currentFace || !currentFace->IsInside(pos)){
    FindCurrentFace();
  }

  if (currentFace){
    
    int eEdge_out=0;   // the eEdge we are leaving currentFace through
    REAL likelyhood=0; // the likelyhood that this is true
    ePoint *cross_p=NULL;// the ePoint we are crossing it on
    eEdge  *cross_e=NULL;
    
    do{
      eEdge_out=-1;
      likelyhood=-1E20;
      REAL ratio=1;

      REAL e_ratio=0,ei_ratio=0;

      if (!currentFace->IsInside(stop)){
	
	// check the edges of the current eFace
	for(int i=0;i<=2;i++){
	  ePoint *new_cross_p=e.IntersectWith(currentFace->e[i]);
	  if (new_cross_p 
	      && (stop-start)*
	      (*(currentFace->p[se_Left(i)]) - *(currentFace->p[se_Right(i)])) <=0
	      ){
	    e_ratio =e.Ratio(*new_cross_p);
	    ei_ratio=currentFace->e[i]->Ratio(*new_cross_p);
	    
	    REAL la=e_ratio*(1-e_ratio);
	    REAL lb=ei_ratio*(1-ei_ratio);
	    REAL this_likelyhood=la+lb+0.00203;
	    if (la<0) this_likelyhood-=1;
	    if (la<EPS) this_likelyhood-=.00001;
	    if (la<=0) this_likelyhood-=.001;
	    if (lb<0) this_likelyhood-=1;
	    if (lb<EPS) this_likelyhood-=.00001;
	    if (lb<=0) this_likelyhood-=.001;
	    
	    // measures of how far in the interior of our line we are
	    if (this_likelyhood>likelyhood){
	      eEdge_out=i;
	      likelyhood=this_likelyhood;
	      tDESTROY_PTR(cross_p);
	      cross_p=new_cross_p;
	      ratio=e_ratio;
	    }
	  }
	  if (new_cross_p && cross_p!=new_cross_p){
	    tDESTROY_PTR(new_cross_p);
#ifdef DEBUG
	    if (!cross_p && !(*e.p[0] == *e.p[1]))
	      se_CheckGrid();
#endif
	  }
	}
      }

      if (eEdge_out>=0){
	cross_e=currentFace->e[eEdge_out];
	
	if (likelyhood <0) {
	  con << "Likelyhood=" << likelyhood << '\n';
	  con << "On its way from " << pos << " to " << stop << ",\n";
	}

	REAL time=startTime+(endTime-startTime)*ratio;
	
	pos=*cross_p;
	
	if (likelyhood <0) 
	  con << "Gameobject at " << pos << " leaves eFace " << *currentFace <<'\n';

	PassEdge(cross_e,time,ei_ratio,0);
	
	currentFace=cross_e->Other(currentFace);
	
	if (currentFace && likelyhood <0)
	  con << "\tand enters " << *currentFace
	       << " through eEdge\n" << *cross_e << '\n';
	
	start=*cross_p;
	startTime=time;
      }
      tDESTROY_PTR(cross_p); // cleanup
    }
    while(currentFace && 
	  !currentFace->IsInside(stop) && 
	  eEdge_out>=0);
  }

  pos=stop;

  if (!currentFace || !currentFace->IsInside(pos)){
    FindCurrentFace();
  }

  //#ifdef DEBUG
  //se_CheckGrid();
  //#endif

  if (id<0)
    currentFace = NULL;
}






  /* the old way
  if (!currentFace || !currentFace->IsInside(pos))
    FindCurrentFace();
  
  if (currentFace){
    //if (pp_out) currentFace->DebugPlot(PD_CreateColor(DoubleBuffer,0,255,0));
    ePoint start(pos),stop(dest);
    eEdge  e(&start,&stop);
    int eEdge_out=0;   // the eEdge we are leaving currentFace through
    ePoint *cross_p=NULL;// the ePoint we are crossing it on
    eEdge  *cross_e=NULL;
    
    while(currentFace && eEdge_out>=0){
      eEdge_out=-1;

      for(int i=0;i<=2 && eEdge_out<0;i++){
	cross_p=e.IntersectWith(currentFace->e[i]);
	if (cross_p){
	  REAL ratio=e.Ratio(*cross_p);

	  if (ratio>EPS){
	    eEdge_out=i;
	    cross_e=currentFace->e[i];
	    
	    REAL time=startTime+(endTime-startTime)*ratio;

	    PassEdge(cross_e,time,cross_e->Ratio(*cross_p),0);
	    
	    currentFace=cross_e->Other(currentFace);
	    
	    start=*cross_p;
	    startTime=time;
	  }
	}
      }
      
    }
    
    if (cross_p) {delete cross_p;cross_p=0;} // cleanup
    
  }
  pos=dest;

  */

void eGameObject::FindCurrentFace(){
  // ack! make it better.

  /*

  */
  if (eFace::faces.Len()<1)
    return;

  if (!currentFace)
    currentFace=eFace::faces(0);

  int timeout=eFace::faces.Len()+2;

  while (currentFace && timeout >0 && !currentFace->IsInside(pos)){
    timeout--;
    // find the neares corner
    /*
    int nearest=2;
    REAL nearest_dist=(*currentFace->p[nearest]-pos).Norm_squared();
    for(int i=1;i>=0;i--){
      REAL dist=(*currentFace->p[i]-pos).Norm_squared();
      if (dist<nearest_dist){
	nearest=i;
	nearest_dist=dist;
      }
    }
    */
    #define nearest 0

    eCoord vec=pos-*currentFace->p[nearest]; // the vector to our destination

    REAL l=-currentFace->LeftVec(nearest)*vec;
    REAL r=currentFace->RightVec(nearest)*vec;
    
    // choose the right path
    if (l>0 || r>0){
      if (l<r)
	currentFace=currentFace->e[se_Left(nearest)]->Other(currentFace);
      else
	currentFace=currentFace->e[se_Right(nearest)]->Other(currentFace);
    }
    else
      currentFace=currentFace->e[nearest]->Other(currentFace);
  }

  if (timeout<=0){ // normal way failed
#ifdef DEBUG
    con << "WARNING! FindCurrentFace failed.\n";
#endif
    // do it the hard way:
    for(int i=eFace::faces.Len()-1;i>=0;i--)
      if(eFace::faces(i)->IsInside(pos)){
	currentFace=eFace::faces(i);
	i=-1;
      }
  }
}

  // simulates behaviour up to currentTime:
bool eGameObject::Timestep(REAL){return 0;}
  // return value: shall this object be destroyed?

void eGameObject::Kill(){}

  // draws it to the screen using OpenGL 
void eGameObject::Render(){}

// Cockpit
bool eGameObject::RenderCockpitFixedBefore(bool){return true;}
  // return value: draw everything else?

  // the same purpose, but called after main rendering
void eGameObject::RenderCockpitFixedAfter(bool){}   
  // virtual perspective
void eGameObject::RenderCockpitVirtual(bool){}


#ifdef POWERPAK_DEB
void eGameObject::PPDisplay(){
  PD_PutPixel(DoubleBuffer,
	      se_X_ToScreen(pos.x),
	      se_Y_ToScreen(pos.y),
	      PD_CreateColor(DoubleBuffer,255,0,100));
  PD_PutPixel(DoubleBuffer,
	      se_X_ToScreen(pos.x+1),
	      se_Y_ToScreen(pos.y),
	      PD_CreateColor(DoubleBuffer,255,0,100));
  PD_PutPixel(DoubleBuffer,
	      se_X_ToScreen(pos.x-1),
	      se_Y_ToScreen(pos.y),
	      PD_CreateColor(DoubleBuffer,255,0,100));
  PD_PutPixel(DoubleBuffer,
	      se_X_ToScreen(pos.x),
	      se_Y_ToScreen(pos.y+1),
	      PD_CreateColor(DoubleBuffer,255,0,100));
  PD_PutPixel(DoubleBuffer,
	      se_X_ToScreen(pos.x),
	      se_Y_ToScreen(pos.y-1),
	      PD_CreateColor(DoubleBuffer,255,0,100));

}
#endif

// Receives control from player; nothing to do here
bool eGameObject::Act(uActionPlayer *,REAL){return false;}


bool eGameObject::TimestepThis(REAL currentTime,eGameObject *c){
#ifdef DEBUG
  se_CheckGrid();
#endif

#ifdef DEBUG
  REAL maxstep=20;
#else
  REAL maxstep=.2;

 // don't do a thing if the timestep is too small
 if (fabs(currentTime - c->lastTime) < .001)
    return false;

  // be more careful when going back
  if (currentTime<c->lastTime)
    maxstep=.1;
#endif

  int number_of_steps=int(fabs((currentTime-c->lastTime)/maxstep));
  if (number_of_steps<1)
    number_of_steps=1;

  REAL lastTime=c->lastTime;

  bool ret=false;

  for(int i=1;i<=number_of_steps;i++)
    ret = ret || c->Timestep(lastTime+i*(currentTime-lastTime)/number_of_steps);

#ifdef DEBUG
  se_CheckGrid();
#endif

  return ret;
}

  // does a timestep and all interactions for every eGameObject
void eGameObject::s_Timestep(REAL currentTime){
#ifdef DEBUG
  se_CheckGrid();
#endif

  for(int i=gameObjects.Len()-1;i>=0;i--){
    se_FetchAndStoreSDLInput();
    eGameObject *c=gameObjects(i);
    
    REAL simTime=currentTime;
    // backdate the object a bit
#ifndef DEDICATED
    if (sn_GetNetState()==nCLIENT && !sr_predictObjects)
#endif
      simTime -= c->Lag();

    if (!eWallRim::IsBound(c->pos,-20))
      c->Kill();
    else if (TimestepThis(simTime,c)){
      if (c->autodelete)
	c->RemoveFromGame();
      else{
	c->RemoveFromList();
	c->currentFace=NULL;
      }
    }
    else if (sn_GetNetState()!=nSERVER)
      for(int j=gameObjects.Len()-1;j>=0;j--)
	c->InteractWith(gameObjects(j),currentTime,0);
    
  }

#ifdef DEBUG
  se_CheckGrid();
#endif

}

#ifdef DEBUG
eGameObject *displayed_gameobject = 0;
#endif

void eGameObject::RenderAll(){
  if (!sr_glOut)
    return;

  for(int i=gameObjects.Len()-1;i>=0;i--){
    se_FetchAndStoreSDLInput();
    if (sr_glOut){
#ifdef DEBUG
      displayed_gameobject = gameObjects(i);
#endif
      gameObjects(i)->Render();
#ifdef DEBUG
      displayed_gameobject = 0;
#endif
    }
  }
}

#ifdef POWERPAK_DEB
void eGameObject::PPDisplayAll(){
  for(int i=gameObjects.Len()-1;i>=0;i--){
    if (pp_out) gameObjects(i)->PPDisplay();
  }
}
#endif


void eGameObject::DeleteAll(){
  int i;
  for(i=gameObjects.Len()-1;i>=0;i--){
    gameObjects(i)->Kill();
    if (gameObjects(i)->autodelete) gameObjects(i)->RemoveFromGame();
#ifdef POWERPAK_DEB
    if (pp_out) gameObjects(i)->PPDisplay();
#endif
  }
}



