/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tMemManager.h"
#include "ePlayer.h"
#include "tInitExit.h"
#include "tConfiguration.h"
#include "eNetGameObject.h"
#include "rConsole.h"
#include "eTimer.h"
#include "rFont.h"
#include "uMenu.h"
#include "tToDo.h"
#include "rScreen.h"
#include <string.h>
#include <fstream.h>
#include "rRender.h"

List<ePlayerNetID> se_PlayerNetIDs;

static char *default_instant_chat[MAX_INSTANT_CHAT]=
{"LOL!",
 ":-)",
 ":-(",
 "Well done!",
 "Almost got you...",
 "Hehe!",
 "Got one!",
 "",
 "",
 "",
 "",
 ""};




ePlayer * ePlayer::PlayerConfig(int p){
  uPlayerPrototype *P = uPlayerPrototype::PlayerConfig(p);
  return dynamic_cast<ePlayer*>(P);
//  return (ePlayer*)P;
}

void   ePlayer::StoreConfitem(tConfItemBase *c){
  assert(CurrentConfitem < PLAYER_CONFITEMS);
  configuration[CurrentConfitem++] = c;
}

void   ePlayer::DeleteConfitems(){
  while (CurrentConfitem>0){
    CurrentConfitem--;
    tDESTROY(configuration[CurrentConfitem]);
  }
}

uActionPlayer *ePlayer::se_instantChatAction[MAX_INSTANT_CHAT];


ePlayer::ePlayer(){
  CurrentConfitem = 0;

  name << "Player " << id+1;
  
  tString confname;
  
  confname << "PLAYER_"<< id+1;
  StoreConfitem(tNEW(tConfItemLine) (confname,
				    "Player name",
				    name));

  confname.Clear();
  confname << "CAMCENTER_"<< id+1;
  centerIncamOnTurn=true;
  StoreConfitem(tNEW(tConfItem<bool>) 
		(confname,
		 "Center internal camera on driving direction",
		 centerIncamOnTurn) );

  confname.Clear();
  startCamera=CAMERA_SMART;
  confname << "START_CAM_"<< id+1;
  StoreConfitem(tNEW(tConfItem<int>) (confname,
				     "Initial Camera",
				     (int &)startCamera));

  confname.Clear();
  confname << "START_FOV_"<< id+1;
  startFOV=90;
  StoreConfitem(tNEW(tConfItem<int>) (confname,
				     "Initial field of vision",
				     startFOV));
  confname.Clear();

  int i;
  for(i=CAMERA_SMART_IN;i>=0;i--){
    confname << "ALLOW_CAM_"<< id+1 << "_" << i;
    StoreConfitem(tNEW(tConfItem<bool>) (confname,
					"Allow/frobid the different "
					"camera modes",
					allowCam[i]));
    allowCam[i]=true;
    confname.Clear();
  }

  for(i=MAX_INSTANT_CHAT-1;i>=0;i--){
    confname << "INSTANT_CHAT_STRING_" << id+1 << '_' <<  i+1;
    StoreConfitem(tNEW(tConfItemLine) (confname,
				      "Instant chat available with hotkeys",
				      instantChatString[i]));
    instantChatString[i]=default_instant_chat[i];
    confname.Clear();
  }

  confname << "SPECTATOR_MODE_"<< id+1;
  StoreConfitem(tNEW(tConfItem<bool>)(confname,
				     "Sets spectator mode for this player",
				     spectate));
  spectate=false;
  confname.Clear();
  
  confname << "AUTO_INCAM_"<< id+1;
  autoSwitchIncam=false;
  StoreConfitem(tNEW(tConfItem<bool>) (confname,
				      "Automatically switch to internal "
				      "camera in a maze",
				      autoSwitchIncam));
  confname.Clear();

  confname << "CAMWOBBLE_"<< id+1;
  wobbleIncam=false;
  StoreConfitem(tNEW(tConfItem<bool>) (confname,
				      "Lets the internal camera move "
				      "with your cycle",
				      wobbleIncam));

  confname.Clear();
  confname << "COLOR_B_"<< id+1;
  StoreConfitem(tNEW(tConfItem<int>) (confname,
				     "Cycle and wall color, blue component",
				     rgb[2]));

  confname.Clear();
  confname << "COLOR_G_"<< id+1;
  StoreConfitem(tNEW(tConfItem<int>) (confname,
				     "Cycle and wall color, green component",
				     rgb[1]));

  confname.Clear();
  confname << "COLOR_R_"<< id+1;
  StoreConfitem(tNEW(tConfItem<int>) (confname,
				     "Cycle and wall color, red component",
				     rgb[0]));
  confname.Clear();

  static REAL R[MAX_PLAYERS]={1,.2,.2,1};
  static REAL G[MAX_PLAYERS]={.2,1,.2,1};
  static REAL B[MAX_PLAYERS]={.2,.2,1,.2};
  
  rgb[0]=int(R[id]*15);
  rgb[1]=int(G[id]*15);
  rgb[2]=int(B[id]*15);
  
  cam=NULL;
}

ePlayer::~ePlayer(){
  tCHECK_DEST;
  DeleteConfitems();
}

#ifndef DEDICATED
void ePlayer::Render(){
  if (cam) cam->Render();
}
#endif


void handle_chat(nMessage &m){
  if(sn_GetNetState()==nSERVER){
    unsigned short id;
    m.Read(id);
    tString say;
    m >> say;

    
    
    // arg! add security!
    ePlayerNetID *p=(ePlayerNetID *)nNetObject::ObjectDangerous(id);

    if (p){
      // spam protection:
      p->spamProtect++;
      p->spamProtect-=tSysTimeFloat()-p->spamProtectTime;
      p->spamProtectTime=tSysTimeFloat();
      if (p->spamProtect<0)
	p->spamProtect=0;
      
      if (p->spamProtect>5){
	tString message;
	p->spamProtect+=10;
      
	message << ColorString (1,1,0) 
		<< "SPAM PROTECTION: you are silenced for the next "
		<< p->spamProtect-5 << " seconds.\n";
	
	sn_ConsoleOut(message,m.SenderID());
      }
      else{
	tString message;
	message << *p;
	message << " : " << ColorString(1,1,.5)
		<< say << '\n';
	
	sn_ConsoleOut(message);
      }
    }
  }
}

static nDescriptor chat_handler(23,handle_chat,"Chat");

static void send_chat(ePlayer *me,const tString &s){
  int id=-1;
  for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--)
    if (se_PlayerNetIDs(i)->pID==me->ID())
      id=i;
  if (id>=0){
    switch (sn_GetNetState()){
    case nCLIENT:
      {
	nMessage *m=tNEW(nMessage) (chat_handler);
	m->Write(se_PlayerNetIDs(id)->ID());
	*m << s;
	m->Send(0);
      }
      break;
    default:
      {
	tString message;
	message << *me;
	message << " : " << ColorString(1,1,.5)
		<< s << '\n';
	sn_ConsoleOut(message);
	
	break;
      }
    }
  }
}


class eMenuItemChat: uMenuItemString{
  ePlayer *me;
public:
  eMenuItemChat(uMenu *M,tString &c,ePlayer *Me):
    uMenuItemString(M,"Say:","",c),me(Me){}

  virtual ~eMenuItemChat(){}

  //virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0);

  virtual bool Event(SDL_Event &e){
#ifndef DEDICATED
    if (e.type==SDL_KEYDOWN && 
	(e.key.keysym.sym==SDLK_KP_ENTER || e.key.keysym.sym==SDLK_RETURN)){

      send_chat(me,*content);
      
      MyMenu()->Exit();
      return true;
    }
    else if (e.type==SDL_KEYDOWN && 
	     uActionGlobal::IsBreakingGlobalBind(e.key.keysym.sym))
      return su_HandleEvent(e);
    else
#endif
      return uMenuItemString::Event(e);
  }
};


void se_ChatState(bool cs){
  for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--)
    if (se_PlayerNetIDs[i]->Owner()==sn_myNetID){
      se_PlayerNetIDs[i]->chatting=cs;
      se_PlayerNetIDs[i]->RequestSync();
    }
}

static ePlayer *chatter=NULL;
void do_chat(){
  if (chatter){
    se_ChatState(true);

    sr_con.SetHeight(15,false);
    se_SetShowScoresAuto(false);

    tString say;
    uMenu chat_menu("",false);
    eMenuItemChat s(&chat_menu,say,chatter);
    chat_menu.SetCenter(-.75);
    chat_menu.SetBot(-2);
    chat_menu.SetTop(-.7);
    chat_menu.Enter();
    
    se_ChatState(false);

    sr_con.SetHeight(7,false);
    se_SetShowScoresAuto(true);
    chatter=NULL;
  }
}



bool ePlayer::Act(uAction *act,REAL x){
  eGameObject *object=NULL;

  if (s_chat==*(uActionPlayer *)act){
    if(x>0) {
      chatter=this;
      st_ToDo(&do_chat);
    }
    return true;
  }

  else{
    int i;
    for(i=MAX_INSTANT_CHAT-1;i>=0;i--){
      if (*se_instantChatAction[i] == *(uActionPlayer *)act && x>=0){
	send_chat(this,instantChatString[i]);
      }
    }
    
    for(i=se_PlayerNetIDs.Len()-1;i>=0;i--)
      if (se_PlayerNetIDs[i]->pID==id && se_PlayerNetIDs[i]->object)
	object=se_PlayerNetIDs[i]->object;
    
    return ((cam    && cam->Act((uActionCamera *)act,x)) ||
	    (object && se_GameTime()>=0 && object->Act((uActionPlayer *)act,x)));
  }

}

rViewport * ePlayer::PlayerViewport(int p){
  if (!PlayerConfig(p)) return NULL;
  
  for (int i=MAX_VIEWPORTS-1;i>=0;i--)
    if (sr_viewportBelongsToPlayer[i] == p)
      return rViewportConfiguration::CurrentViewport(i);
  
  return NULL;
}

bool ePlayer::PlayerIsInGame(int p){
  return PlayerViewport(p) && PlayerConfig(p);
}

static tConfItemBase *vpbtp[MAX_VIEWPORTS];

static void p_init(){
  int i;
  for(i=MAX_INSTANT_CHAT-1;i>=0;i--){
    tString id;
    id << "INSTANT_CHAT_";
    id << i+1;
    tString desc;
    desc << "Instant Chat ";
    desc << i+1;
    ePlayer::se_instantChatAction[i]=tNEW(uActionPlayer)
      (id,desc,
       "Issues a special instant chat macro.");
  }
  

  for(i=MAX_VIEWPORTS-1;i>=0;i--){
    tString id;
    id << "VIEWPORT_TO_PLAYER_";
    id << i+1;
    vpbtp[i] = tNEW(tConfItem<int>(id,"Assign this viewport to a player",
		           s_newViewportBelongsToPlayer[i]));
    s_newViewportBelongsToPlayer[i]=i;
  }
}

static void p_exit(){
  int i;
  for(i=MAX_INSTANT_CHAT-1;i>=0;i--)
    tDESTROY(ePlayer::se_instantChatAction[i]);

  for(i=MAX_VIEWPORTS-1;i>=0;i--)
    tDESTROY(vpbtp[i]);
}

static tInitExit p_ie(p_init, p_exit);

uActionPlayer ePlayer::s_chat("CHAT","chat",
			     "Lets you talk to other players over "
			     "the network.");

int pingCharity;

ePlayerNetID::ePlayerNetID(int p):nNetObject(),listID(-1)
  ,pID(p){

  greeted=true;
  
  chatting=false;

  if (p>=0){
    ePlayer *P = ePlayer::PlayerConfig(p);
    if (P){
      name=P->Name();
      r=   P->rgb[0];
      g=   P->rgb[1];
      b=   P->rgb[2];
      pingCharity=::pingCharity;
    }
  }
  else
    name="AI";

  se_PlayerNetIDs.Add(this,listID);
  object=NULL;

  if(sn_GetNetState()!=nSERVER)
    ping=sn_ping[0];
  else
    ping=0; // hehe! server has no ping.

  spamProtect=0;
  spamProtectTime=tSysTimeFloat();

  lastSync=tSysTimeFloat();

  RequestSync();
  score=0;
}

ePlayerNetID::ePlayerNetID(nMessage &m):nNetObject(m),listID(-1){
  greeted=false;
  chatting=false;
  pID=-1;
  se_PlayerNetIDs.Add(this,listID);
  object=NULL;
  ping=sn_ping[m.SenderID()];
  lastSync=tSysTimeFloat();

  if(sn_GetNetState()==nSERVER)
    RequestSync();

  spamProtect=0;
  spamProtectTime=tSysTimeFloat();
  score=0;
}

ePlayerNetID::~ePlayerNetID(){
  se_PlayerNetIDs.Remove(this,listID);

  if (sn_GetNetState()==nSERVER){
    tString mess;
    mess << *this << ColorString(1,.5,.5) << " left the game with " << score << " points.\n";
    sn_ConsoleOut(mess);
  }

  ClearObject();
  //con << "Player info sent.\n";

  for(int i=MAX_PLAYERS-1;i>=0;i--){
    ePlayer *p = ePlayer::PlayerConfig(i);

    if (p && p->netPlayer==this)
      p->netPlayer=NULL;
  }
}

bool ePlayerNetID::ActionOnQuit(){
  if (sn_GetNetState()==nSERVER){
    tString mess;
    mess << *this << ColorString(1,.5,.5) << " is leaving the game.\n";
    sn_ConsoleOut(mess);
  }
  return true;
}

bool ePlayerNetID::AcceptClientSync() const{
  return true;
}

void ePlayerNetID::WriteSync(nMessage &m){
  lastSync=tSysTimeFloat();
  nNetObject::WriteSync(m);
  m.Write(r);
  m.Write(g);
  m.Write(b);
  m.Write(pingCharity);
  m << name; 

  //if(sn_GetNetState()==nSERVER)
  m << ping;
  m << (unsigned short) chatting;
  m << score;
}

void ePlayerNetID::ReadSync(nMessage &m){ 
  nNetObject::ReadSync(m);

  tString oldname(name);


  m.Read(r);
  m.Read(g);
  m.Read(b);

  m.Read(pingCharity);

  m >> name;
  if (sn_GetNetState()==nSERVER){
    tString mess;

    if(name.Len()>16)
      name.SetLen(16);
    name[name.Len()]='\0';

    if (oldname.Len()<=1){
      mess << *this;
      mess << ColorString(.5,1,.5) << " entered the game.\n";
    }
    else if (strcmp(oldname,name))
      mess << oldname << " renamed to " << *this << ".\n";
    sn_ConsoleOut(mess);
  }
  if (sn_GetNetState()==nCLIENT && owner==::sn_myNetID)
    name=oldname;

  REAL p;
  m >> p;
  if (sn_GetNetState()!=nSERVER)
    ping=p;
  
  if (!m.End()){
    unsigned short newchat;
    m >> newchat;
    chatting=newchat;
  }

  if (!m.End()){
    if(sn_GetNetState()!=nSERVER)
      m >> score;
    else{
      int s;
      m >> s;
    }
  }
  // con << "Player info updated.\n";
}


nNOInitialisator<ePlayerNetID> ePlayerNetID_init(24,"ePlayerNetID");

nDescriptor &ePlayerNetID::CreatorDescriptor() const{
  return ePlayerNetID_init;
}



void ePlayerNetID::ControlObject(eNetGameObject *c){
  if (object && c!=object)
    ClearObject();
  object=c;
#ifdef DEBUG
  //con << "Player " << name << " controlles new object.\n";
#endif
}

void ePlayerNetID::ClearObject(){
  if (object){
    eNetGameObject *x=object;
    object=NULL;
    x->RemoveFromGame();
  }
#ifdef DEBUG
  //con << "Player " << name << " controlles nothing.\n";
#endif
}


void ePlayerNetID::Greet(){
  if (!greeted){
    tString s;
    
    s << "\n\nWelcome " << name  << "! This server is running version " << sn_programVersion
      << ".\n";
    GreetHighscores(s);
    for(int k=0;k<4;k++)
      if (sn_greeting[k].Len()>1)
	s << sn_greeting[k] << "\n";
    s << '\n';
    //cout << s;
    sn_ConsoleOut(s,owner);
    greeted=true;
  }
}

/*
  void ePlayerNetID::create_cycle(const eCoord &pos,const eCoord &dir){
  
  gCycle *c=tNEW(gCycle) (pos,dir,this,0);
  object=c;
  //c->Release(); // so noone can complain when we delete it in ClearObject()..
  } */

eNetGameObject *ePlayerNetID::Object(){
  return object;
}

void se_SaveToScoreFile(const tString &s){
#ifdef DEBUG
  if (sn_GetNetState()!=nCLIENT){
#else
    if (sn_GetNetState()==nSERVER){
#endif
      ofstream o("scorelog.txt",ios::app);
      o << RemoveColors(s);
    }
#ifdef DEBUG
  }
#else
}
#endif

void ePlayerNetID::AddScore(int points,char *reason){
  if (points==0)
    return;
  
  score+=points;
  tString message;
  message << *this;
  message << ColorString(1,1,1);
  if (points>0)
    message << " got " << points << " points ";
  else
    message << " lost " << -points << " points ";
  message << reason << '\n';
  
  sn_ConsoleOut(message);
  RequestSync(true);
  
  se_SaveToScoreFile(message);
}





void ePlayerNetID::SwapPlayersNo(int a,int b){
  if (0>a || se_PlayerNetIDs.Len()<=a)
    return;
  if (0>b || se_PlayerNetIDs.Len()<=b)
    return;
  if (a==b)
    return;

  ePlayerNetID *A=se_PlayerNetIDs(a);
  ePlayerNetID *B=se_PlayerNetIDs(b);

  se_PlayerNetIDs(b)=A;
  se_PlayerNetIDs(a)=B;
  A->listID=b;
  B->listID=a;
}



void ePlayerNetID::SortByScore(){
  // bubble sort (AAARRGGH! but good for lists that change not much)
  
  bool inorder=false;
  while (!inorder){
    inorder=true;
    int i;
    for(i=se_PlayerNetIDs.Len()-2;i>=0;i--)
      if (se_PlayerNetIDs(i)->score<se_PlayerNetIDs(i+1)->score){
	SwapPlayersNo(i,i+1);
	inorder=false;
      }
  }
}

void ePlayerNetID::ResetScore(){
    int i;
    for(i=se_PlayerNetIDs.Len()-1;i>=0;i--){
      se_PlayerNetIDs(i)->score=0;
      if (sn_GetNetState()==nSERVER)
	se_PlayerNetIDs(i)->RequestSync();
    }
}

void ePlayerNetID::DisplayScores(){
  sr_ResetRenderState(true);

  REAL W=sr_screenWidth;
  REAL H=sr_screenHeight;

  REAL MW=400;
  REAL MH=(MW*3)/4;

  if(W>MW)
    W=MW;

  if(H>MH)
    H=MH;

#ifndef DEDICATED
  if (sr_glOut){
    Color(1,1,1);
    rTextField c(-.7,.6,10/W,18/H);
    c << Ranking();
  }
#endif
}


tString ePlayerNetID::Ranking(){
  SortByScore();

  tString ret;
  
  if (se_PlayerNetIDs.Len()>0){
    ret << ColorString(1,.5,.5);
    ret << "Name:";
    ret << ColorString(1,1,1);
    ret.SetPos(30);
    ret << "Score:";
    ret.SetPos(40);
    ret << "Ping:";
    ret.SetPos(50);
    ret << "Ping Charity:\n";
    
    
    for(int i=0;i<se_PlayerNetIDs.Len();i++){
      tString line;
      ePlayerNetID *p=se_PlayerNetIDs(i);
      line << *p;
      line << ColorString(1,1,1);
      line.SetPos(30);
      line << p->score;
      line.SetPos(40);
      line << int(p->ping*1000);
      line.SetPos(50);
      line << p->pingCharity;
      ret << line << "\n";
    }
  }
  else
    ret << "Nobody there.\n";
  return ret;
}



tString & operator << (tString &s,const ePlayer &p){
  return s << ColorString(p.rgb[0]/15.0,
			  p.rgb[1]/15.0,
			  p.rgb[2]/15.0)
	   << p.Name();
}

tString & operator << (tString &s,const ePlayerNetID &p){
  return s << ColorString(p.r/15.0,
			  p.g/15.0,
			  p.b/15.0)
	   << p.name;
}



void ePlayerNetID::CompleteRebuild(){
  for(int i=MAX_PLAYERS-1;i>=0;i--){
    ePlayer *local_p=ePlayer::PlayerConfig(i);
    if (local_p)
      local_p->netPlayer = NULL;
  }

  Update();
}

  // Update the netPlayer_id list
void ePlayerNetID::Update(){
  rViewport::Update(MAX_PLAYERS);
#ifdef DEDICATED
   if (sr_glOut)
#endif
    {

      for(int i=MAX_PLAYERS-1;i>=0;i--){
	bool in_game=ePlayer::PlayerIsInGame(i);
	ePlayer *local_p=ePlayer::PlayerConfig(i);
	tCONTROLLED_PTR(ePlayerNetID) &p=local_p->netPlayer;

	if (!p && in_game && !local_p->spectate) // insert new player	
	  p=tNEW(ePlayerNetID) (i);

	if (bool(p) && (!in_game || local_p->spectate) && // remove player
	    (sn_GetNetState()!=nSERVER ||
	     p->Owner()!=0))
	  p=0;
	
	if (bool(p) && in_game){ // update
	  p->r=ePlayer::PlayerConfig(i)->rgb[0];
	  p->g=ePlayer::PlayerConfig(i)->rgb[1];
	  p->b=ePlayer::PlayerConfig(i)->rgb[2];
	  p->pingCharity=::pingCharity;
	  p->name=ePlayer::PlayerConfig(i)->Name();	
	}
      }

    }
   // update the ping charity
   int old_c=sn_pingCharityServer;
   sn_pingCharityServer=::pingCharity;
#ifndef DEDICATED
   if (sn_GetNetState()==nCLIENT)
#endif
     sn_pingCharityServer+=100000;

   int i;
   for(i=se_PlayerNetIDs.Len()-1;i>=0;i--){
     ePlayerNetID *pni=se_PlayerNetIDs(i);
     int new_ps=pni->pingCharity;
     new_ps+=int(pni->ping*500);
     
     if (new_ps< sn_pingCharityServer)
       sn_pingCharityServer=new_ps;
   }
   if (sn_pingCharityServer<0)
     sn_pingCharityServer=0;
   if (old_c!=sn_pingCharityServer)
     con << "Ping charity changed from " << old_c << " to " 
	 << sn_pingCharityServer << "\n";
   
}
 
 

static bool show_scores=false;
static bool ass=true;

void se_AutoShowScores(){
  if (ass)
    show_scores=true;
}


void se_UserShowScores(bool show){
  show_scores=show;
}

void se_SetShowScoresAuto(bool a){
  ass=a;
}

 
static void scores(){
  if (show_scores){
    ePlayerNetID::DisplayScores();
  }
}


static rPerFrameTask pf(&scores);

static bool force_small_cons(){
  return show_scores;
}

static rSmallConsoleCallback sc(&force_small_cons);

static void cd(){
  show_scores = false;
}



static uActionGlobal score("SCORE","score",
			   "Shows you the score table.");


static bool sf(REAL x){
  if (x>0) show_scores = !show_scores;
  return true;  
}

static uActionGlobalFunc saf(&score,&sf);

static ePlayer se_Players[MAX_PLAYERS];


static rCenterDisplayCallback c_d(&cd);

