/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_PLAYER_H
#define ArmageTron_PLAYER_H

#define MAX_INSTANT_CHAT 12
#define MAX_PLAYERS 4

#include "uInput.h"
#include "tList.h"
#include "tString.h"
#include "eCamera.h"
#include "eNetGameObject.h"

#define PLAYER_CONFITEMS 40

class tConfItemBase;

class ePlayer: public uPlayerPrototype{
  friend class eMenuItemChat;
  static uActionPlayer s_chat;

  tConfItemBase *configuration[PLAYER_CONFITEMS];
  int            CurrentConfitem;
  void   StoreConfitem(tConfItemBase *c);
  void   DeleteConfitems();
public:
  tString     name;
  bool       centerIncamOnTurn;
  bool       wobbleIncam;
  bool       autoSwitchIncam;
  bool       spectate;

  eCamMode startCamera;
  bool     allowCam[10];
  int      startFOV;

  tCHECKED_PTR(eCamera)           cam;
  tCONTROLLED_PTR(ePlayerNetID) netPlayer;

  int rgb[3]; // our color

  tString instantChatString[MAX_INSTANT_CHAT];
  // instant chat macros

  static uActionPlayer *se_instantChatAction[MAX_INSTANT_CHAT];

  ePlayer();
  virtual ~ePlayer();

  virtual const char *Name() const{return name;}
 
  virtual bool Act(uAction *act,REAL x);

  int ID(){return id;};
#ifndef DEDICATED
  void Render();
#endif
  
  static ePlayer * PlayerConfig(int p);

  static bool PlayerIsInGame(int p);

  static rViewport * PlayerViewport(int p);
};


/*
class eTeam: public nNetObject{
  friend class ePlayerNetID;
  
public:
  int score;

};
*/

// the class that identifies players across the network
class ePlayerNetID: public nNetObject{
  friend class ePlayer;
  friend class eNetGameObject;

  int listID;

  tCHECKED_PTR(eNetGameObject) object; // the object this player is 
                                      // controlling
  // eTeam           *team; // the team we are one

  int score; // points made so far

  bool greeted;
  static void SwapPlayersNo(int a,int b); // swaps the players a and b
 public:
  int    pID;
  tString name;
  unsigned short r,g,b; // our color

  bool       chatting; // are we currently chatting?

  unsigned short pingCharity; // max ping you are willing to take over

  REAL ping;

  double lastSync;

  REAL   spamProtect;
  double spamProtectTime;

  ePlayerNetID(int p);
  ePlayerNetID(nMessage &m);
  virtual ~ePlayerNetID();

  virtual bool ActionOnQuit();

  virtual bool AcceptClientSync() const;
  virtual void WriteSync(nMessage &m);
  virtual void ReadSync(nMessage &m);
  virtual nDescriptor &CreatorDescriptor() const;

  void ControlObject(eNetGameObject *c);
  void ClearObject();
  //  void create_cycle(const eCoord &pos,const eCoord &dir);
  void Greet();
  eNetGameObject *Object();

  void AddScore(int points,char *reason);
  int Score()const {return score;}

  static void SortByScore(); // brings the players into the right order
  static tString Ranking();     // returns a ranking list
  static void  ResetScore();  // resets the ranking list

  static void DisplayScores(); // display scores on the screen

  void GreetHighscores(tString &s); // tell him his positions in the 
  // highscore lists (defined in game.cpp)

  static void Update();           // creates ePlayerNetIDs for new players 
                             // and destroys those of players that have left

  static void CompleteRebuild(); // same as above, but rebuilds every ePlayerNetID.
};

extern List<ePlayerNetID> se_PlayerNetIDs;
extern int    sr_viewportBelongsToPlayer[MAX_VIEWPORTS];

void se_ChatState(bool cs);

void se_SaveToScoreFile(const tString &s);

tString & operator << (tString &s,const ePlayer &p);
tString & operator << (tString &s,const ePlayerNetID &p);

extern int pingCharity;

void se_AutoShowScores(); // show scores based on automated decision
void se_UserShowScores(bool show); // show scores based on user input
void se_SetShowScoresAuto(bool a); // disable/enable auto show scores

#endif

