/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "eGameObject.h"
#include "eWall.h"

/* ***************************************************
   eWall:
   *************************************************** */

tHeap<eWallView> se_wallsVisible[MAX_VIEWERS];
List<eWall> se_wallsNotYetInserted;

tHeapBase *eWallView::Heap(){
  return &(se_wallsVisible[viewer]);
}


void eWallView::SetValue(REAL v){
  tHeapElement::value=v;
  se_wallsVisible[viewer].Replace(this);
}

eWall::eWall():edge(NULL){
  id = -1;
  Remove();
  //initialize viewers
  for(int i=MAX_VIEWERS-1;i>=0;i--){
    view[i].Set(i,this);
    se_wallsVisible[i].Insert(&view[i]);
  }
}

eWall::~eWall(){
  if (edge)
    edge->wall=NULL;
  for(int i=MAX_VIEWERS-1;i>=0;i--)
    se_wallsVisible[i].Remove(&view[i]);
  tCHECK_DEST;

  Insert();
}

//ArmageTron_eWalltype eWall::type(){return ArmageTron_GENERIC_WALL;}

void eWall::Flip(){}

bool eWall::Splittable() const {return 0;}
bool eWall::Deletable() const {return 0;}

void eWall::Split(eWall *& s1,eWall *& s2,REAL){
  s1=tNEW(eWall)(*this);
  s2=tNEW(eWall)(*this);
}

void eWall::PassingGameObject(eGameObject *pass,REAL,REAL,int){
  pass->Kill();
}

void eWall::SetVisHeight(int v,REAL h){
  if (h>=SeeHeight()-EPS)
    view[v].SetValue(h);
  else
    view[v].SetValue(-1000);
}


void eWall::Insert(){
  se_wallsNotYetInserted.Remove(this,id);
}


void eWall::Remove(){
  se_wallsNotYetInserted.Add(this,id);
}



