/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_WALL_H
#define ArmageTron_WALL_H

#include "eTess.h"

// ******************************************************************


// ******************************************************************

// a class for the different types of eWalls or similar objects 
// (enery barriers, fault lines...) that may appear in the game

#ifdef WIN32
// disable a hack that apparently only works with gcc
#define CAUTION_WALL
#endif



class eWall;

class eWallView:public tHeapElement{
friend class eWall;
protected:
  virtual tHeapBase *Heap();

#ifdef CAUTION_WALL
  eWall *wall;
#endif

  int  viewer;
public:
  eWallView(){}	
  ~eWallView(){}	

  void Set(int view,eWall *mw){
	viewer=view;
#ifdef CAUTION_WALL
	wall=mw;
#endif
  }

  REAL Value(){return tHeapElement::value;}
  void SetValue(REAL v);
  eWall *Belongs(){
#ifdef CAUTION_WALL
	  return wall;
#else
	  return (eWall *)(&this[-viewer]);
#endif
  }
};

extern tHeap<eWallView> se_wallsVisible[MAX_VIEWERS];

class eWall{
  friend class eEdge;

  eWallView view[MAX_VIEWERS];
protected:
  tCHECKED_PTR(eEdge) edge;
public:
  int id;

  eWall();
  virtual ~eWall();

  const eEdge* Edge()const {return edge;}

  eCoord EndPoint(int i){
    if (edge)
      return *(edge->p[i]);
    else
      return eCoord(0,0);
  }

  eCoord Vec(){
    if (edge)
      return (edge->Vec());
    else
      return eCoord(0,0);
  }
  
  // flip the fall
  virtual void Flip();

  // may we split the eWall in two?
  virtual bool Splittable() const;

  // can we delete the eWall now?
  virtual bool Deletable() const;

  // split the eWall in two with ratio a : 1-a
  virtual void Split(eWall *& w1,eWall *& w2,REAL a);

  // is it still massive? (i.e. is the player it belongs to alive?)
  virtual bool Massive() const{return true;}

  // what happens to a gameobject that passes here?
  virtual void PassingGameObject(eGameObject *pass,REAL time,REAL pos,int recursion=1);

#ifndef DEDICATED
  static void Render_helper(eEdge *e,REAL tBeg,REAL tEnd,REAL h=4,REAL hfrac=1,REAL bot=0);

  // draws it to the screen using OpenGL 
  virtual void Render();
#endif

  // can you see through it?
  virtual REAL BlockHeight() const{return 4;}
  virtual REAL SeeHeight() const{return 4;}

  void Insert();
  void Remove();

  void SetVisHeight(int v,REAL h);
};

extern List<eWall> se_wallsNotYetInserted;

#endif
