/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_NET_CONFIGURATION_H
#define ArmageTron_NET_CONFIGURATION_H

#include "tConfiguration.h"
#include "nNetwork.h"

class nConfItemBase:public virtual tConfItemBase{
 protected:
  nConfItemBase();
public:
  nConfItemBase(const char *title,const char *help);
  virtual ~nConfItemBase();

  virtual void NetReadVal(nMessage &m)=0;
  virtual void NetWriteVal(nMessage &m)=0;

  static void s_GetConfigMessage(nMessage &m);

  virtual void WasChanged();

  virtual bool Writable();

  static void s_SendConfig(int peer=-1);
  void          SendConfig(int peer=-1);
};


template<class T> class nConfItem
: public nConfItemBase,
  public tConfItem<T>,
  public virtual tConfItemBase
{
 protected:
  nConfItem(T& t)
    :tConfItem<T>(t), tConfItemBase("",""){}

    public:
  nConfItem(const char *title,const char *help,T& t)
    :tConfItem<T>(t),
    tConfItemBase(title, help, na){}
  virtual ~nConfItem(){}
  
  
  virtual void NetReadVal(nMessage &m){
    T dummy=0;
    m >> dummy;
    if (dummy!=*target){
      if (printChange)
	con << con.ColorString(1,.3,.3) << title << 
	  " changed from " << *target << " to " << dummy << 
	  " on server order.\n";
      *target=dummy;
      changed=true;
    }
  }

  virtual void NetWriteVal(nMessage &m){
    m << *target;
  }
};

template<class T> class nSettingItem:public nConfItem<T>{
public:
  nSettingItem(const char *title,const char *help,T& t)
    :nConfItem<T>(t), tConfItemBase(title, help){}
  virtual ~nSettingItem(){}

  virtual bool Save(){return false;}
};


class nConfItemLine:public nConfItem<tString>{
 protected:
public:
  nConfItemLine(const char *title,const char *help,tString &s)
    :nConfItem<tString>(s), tConfItemBase(title,help){};
  virtual ~nConfItemLine(){}

  virtual void ReadVal(istream &s);
};

#endif

