/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include <config.h>

#ifndef DEDICATED

#include "tSysTime.h"
#include "rConsole.h"
#include "rFont.h"
#include "rSysdep.h"
#include "rScreen.h"
#include "rGL.h"

static tString sr_centerString;
static REAL center_r,center_g,center_b,center_fadetime;

static REAL Time;

static void sr_ConsolePerFrame(){
  if (sr_con.autoDisplayAtSwap)
    sr_con.Render();
}

static rPerFrameTask console_pf(&sr_ConsolePerFrame);


void rConsole::DisplayAtNewline(){
  bool sw=autoDisplayAtSwap;
  autoDisplayAtSwap=true;
  if (sr_glOut){
    sr_SwapGL();
    sr_ClearGL();
  }
  autoDisplayAtSwap=sw;
}

void rConsole::Render(){
  if (!sr_glOut)
    return;

  sr_ResetRenderState(true);

  REAL W=sr_screenWidth;
  REAL H=sr_screenHeight;

  REAL MW=400;
  REAL MH=(MW*3)/4;

  if(W>MW)
    W=MW;

  if(H>MH)
    H=MH;

  rCWIDTH_CON=10/W;
  rCHEIGHT_CON=18/H;

  /*
  while (W>700){
    rCWIDTH_CON*=2;
    rCHEIGHT_CON*=2;
    W*=.5;
  }
  */

  if (sr_screen){
    Time=tSysTimeFloat();

    if (sr_textOut || rForceTextCallback::ForceText()){
      if(lastCustomTimeout<Time-5 &&
	 lastTimeout+timeout<Time && currentTop<currentIn){
	currentTop++;
	lastTimeout=Time;
      }
      rTextField out(-.95,.99,rCWIDTH_CON,rCHEIGHT_CON,&rFont::s_defaultFontSmall);
      out.SetWidth(1.9/rCWIDTH_CON);

      glColor3f(1,1,1);
      
      int i;
      for(i=currentTop;i<=currentIn && i<=currentTop+MaxHeight();i++)
	if (lines[i].Len()>1){
	  glColor3f(1,1,1);
	  out << lines[i];
	  out.ResetColor();
	}
      if (i<currentIn){
	glColor3f(1,.8,.5);
	out << "       v   v   v   v   v   v   v   v   v\n";
      }
      
      
      int over=out.Lines()-Height();
      if (over>0 && (rSmallConsoleCallback::SmallColsole() || lastCustomTimeout<tSysTimeFloat()-15)){
	lastTimeout=Time;
	currentTop+=(over+1)/2;
      }
    }
      
    if (Time-center_fadetime<2){
      REAL alpha=center_fadetime-Time+1;
      if (alpha>1) alpha=1;
      if (alpha<0) alpha=0;
      glColor4f(center_r,center_g,center_b,alpha);
      
      DisplayText(0,0,rCWIDTH_CON*4,rCHEIGHT_CON*4,sr_centerString);
    }
  }
}


void CenterDisplay(const tString &s,REAL timeout,REAL r,REAL g,REAL b){
  rCenterDisplayCallback::CenterDisplay();

  sr_centerString=s;
  center_fadetime=timeout+tSysTimeFloat();
  center_r=r;
  center_g=g;
  center_b=b;
}

void rConsole::CenterDisplay(const tString &s,REAL timeout,REAL r,REAL g,REAL b){
  rCenterDisplayCallback::CenterDisplay();

  sr_centerString=s;
  center_fadetime=timeout+tSysTimeFloat();
  center_r=r;
  center_g=g;
  center_b=b;
}

#else
#include "rConsoleCout.cpp"
#endif
