/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include <fstream.h>
#include "tConfiguration.h"
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "tString.h"
#include "tToDo.h"
#include "tConsole.h"

bool           tConfItemBase::printChange=true;
tConfItemBase *tConfItemBase::s_ConfItemAnchor=NULL;

bool st_FirstUse=true;
static tConfItem<bool> fu("FIRST_USE","is this the first time you use Armagetron?",st_FirstUse);


tConfItemBase::tConfItemBase(const char *t,const char *h)
  :tListItem<tConfItemBase>(s_ConfItemAnchor),id(-1),title(t),help(h),
  changed(false){

  tConfItemBase *run = s_ConfItemAnchor;
  while (run){
    if (run != this && !strcmp(t,run->title))
      tERR_ERROR_INT("Two tConfItems with the same name " << t << "!");
    run = run->Next();
  }
}

tConfItemBase::~tConfItemBase(){}

void tConfItemBase::SaveAll(ostream &s){
  for(tConfItemBase *ci = s_ConfItemAnchor; ci ; ci = ci->Next()){
    if (ci->Save()){
      s << setw(28) << ci->title << " ";
      ci->WriteVal(s);
      s << "\n";
    }
  }
}

void tConfItemBase::LoadAll(istream &s){
  int line=0;
  while(!s.eof() && s.good()){
    int i;

    tString name;
    s >> name;

    // make name uppercase:
    for(i=name.Len()-1;i>=0;i--)
      name[i]=toupper(name[i]);


    bool found=false;

    if (name[0]=='#'){ // comment. ignore rest of line
      char c=' ';
      while(c!='\n') c=s.get();
      found=true;
    }
    
    if (strlen(name)==0) // ignore empty lines
      found=true;

    for(tConfItemBase *ci=s_ConfItemAnchor;!found && ci; ci = ci->Next()){
      if (!strcmp(name,ci->title)){
	bool cb=ci->changed;
	ci->changed=false;
	ci->ReadVal(s);
	if (ci->changed)
	  ci->WasChanged();
	else
	  ci->changed=cb;
	
	found=true;
      }
    }

    if (!found && printChange){
      con << "Command " << name << " unknown.";
      
      int sim_maxlen=-1;
      for(tConfItemBase *ci = s_ConfItemAnchor; ci ; ci = ci->Next()){
	if (strstr(ci->title,name) && 
	    (int)strlen(ci->title) > sim_maxlen)
	  sim_maxlen=strlen(ci->title);
      }

      if (sim_maxlen>0){
	con << " You probably want:\n";
	for(tConfItemBase *ci = s_ConfItemAnchor; ci ; ci = ci->Next()){
	  if (strstr(ci->title,name)){
	    tString mess;
	    mess << ci->title;
	    mess.SetPos(sim_maxlen+2);
	    mess << "(" << ci->help << ")\n";
	    con << mess;
	  }
	}
      }
      else
	con << '\n';
    }
      
    line++;
  }
  
  //  cout << line << " lines read.\n";
}


/*
void tConfItemBase::ReadVal(istream &s);
void tConfItemBase::WriteVal(istream &s);
*/

tString configfile(){
  tString f;
#ifndef WIN32
  f << getenv("HOME");
  f << "/.ArmageTronrc";
#else
  f << "artr.cfg";
#endif
  return f;
}

void st_LoadConfig(){
  {
    tConfItemBase::printChange=false;

    tString name=configfile();
    ifstream s(name);
    if (s && s.good()) 
      tConfItemBase::LoadAll(s);

    tConfItemBase::printChange=true;
  }

  if (st_FirstUse){
    ifstream s("default.cfg");
    if (s && s.good())
      tConfItemBase::LoadAll(s);
  }
  {
    ifstream s("settings.cfg");
    if (s && s.good())
      tConfItemBase::LoadAll(s);
  }
  { // moviepack config
    ifstream s("moviepack/settings.cfg");
    if (s && s.good())
      tConfItemBase::LoadAll(s);
  }
  {
    ifstream s("autoexec.cfg");
    if (s && s.good())
      tConfItemBase::LoadAll(s);
  }

}

void st_SaveConfig(){
  ofstream s(configfile());
  if (s && s.good())
    tConfItemBase::SaveAll(s);
  else{
    con << "Could not write configuratrion file!\n";
    cerr << "Could not write configuratrion file!\n";
  }
}


void tConfItemLine::ReadVal(istream &s){
  tString dummy;
  dummy.ReadLine(s);
  if(strcmp(dummy,*target)){
    if (printChange)
      con << title << " changed from " << *target << " to " << dummy << ".\n";
    *target=dummy;
    changed=true;
  }

  *target=dummy;
}


void tConfItemLine::WriteVal(ostream &s){
    tConfItem<tString>::WriteVal(s);
}

tConfItemFunc::tConfItemFunc
(const char *title,const char *help,CONF_FUNC *func)
  :tConfItemBase(title,help),f(func){}

tConfItemFunc::~tConfItemFunc(){}

void tConfItemFunc::ReadVal(istream &s){(*f)(s);}
void tConfItemFunc::WriteVal(ostream &){};

bool tConfItemFunc::Save(){return false;}






