/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_STRING_H
#define ArmageTron_STRING_H

#include "tArray.h"

#include <strstream.h>
#include <iostream.h>

//typedef tArray<char> string;

class tString:public tArray<char>{
public:
  tString();
  tString(const char *);
  tString(const tString &);

  void ReadLine(istream &s);

  tString & operator+=(const char *c);
  tString & operator=(const char *c);
  //tString & operator<<(const char *c);
  tString operator+(const char *c) const;
  //tString & operator<<(char c);
  tString & operator+=(char c);
  tString operator+(char c) const;

  operator const char*() const;

  tString & operator=(const tString &s){
    return operator=((const char *)s);}
  tString & operator+=(const tString &s){
    return operator+=((const char *)s);}

  void Clear(){SetLen(0);}

  void SetPos(int len);
};

ostream & operator<< (ostream &s,const tString &x);
istream & operator>> (istream &s,tString &x);

#define tMAX_STRING_OUTPUT 1000
extern char st_stringOutputBuffer[tMAX_STRING_OUTPUT];

template<class T> tString & operator <<(tString &s,const T &c){
  char st_stringOutputBuffer[tMAX_STRING_OUTPUT];
  
  strstream S(st_stringOutputBuffer,
	  tMAX_STRING_OUTPUT-1,
	  ios::out);
  
  S << c << '\0';
  return s+=st_stringOutputBuffer;
}

/*
void operator <<(tString &s,const char * c);
void operator <<(tString &s,const unsigned char * c);
void operator <<(tString &s,int c);
void operator <<(tString &s,float c);
*/


#endif


