/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tMemManager.h"
#include "gArena.h"
#include "eTess.h"
#include "eSpawn.h"
#include "gWall.h"

gArena::gArena():spawnPoints(){
  NewSpawnPoint(eCoord(305,150),eCoord(0,1));
  NewSpawnPoint(eCoord(295,310),eCoord(0,-1));
  NewSpawnPoint(eCoord(250,225),eCoord(1,0));
  NewSpawnPoint(eCoord(350,235),eCoord(-1,0));

  NewSpawnPoint(eCoord(325,100),eCoord(0,1));
  NewSpawnPoint(eCoord(275,360),eCoord(0,-1));
  NewSpawnPoint(eCoord(200,245),eCoord(1,0));
  NewSpawnPoint(eCoord(400,215),eCoord(-1,0));

  NewSpawnPoint(eCoord(285,100),eCoord(0,1));
  NewSpawnPoint(eCoord(315,360),eCoord(0,-1));
  NewSpawnPoint(eCoord(200,205),eCoord(1,0));
  NewSpawnPoint(eCoord(400,255),eCoord(-1,0));

}

void gArena::NewSpawnPoint(const eCoord &loc,const eCoord &dir){
  eSpawnPoint *s=tNEW(eSpawnPoint) (loc,dir);
  spawnPoints.Add(s,s->id);
}


gArena::~gArena(){
  while (spawnPoints.Len()){
    eSpawnPoint *s=spawnPoints(0);
    spawnPoints.Remove(s,s->id);
    delete s;
  }
}

bool init_grid_in_process;

// from gGame.cpp
void exit_game_objects();

void gArena::PrepareGrid(){

  exit_game_objects();

#ifdef POWERPAK_DEB
  if (pp_out){
    PD_ClearSurface(DoubleBuffer, PD_CreateColor(Screen, 0x00, 0x00, 0x00)); 
    
    PD_Color c=PD_CreateColor(DoubleBuffer, 0xFF, 0xFF, 0xFF);
    PD_Line (DoubleBuffer,
	     se_X_ToScreen(600), se_Y_ToScreen(0),
	     se_X_ToScreen(600), se_Y_ToScreen(460),
	     c);   
    PD_Line (DoubleBuffer,
	     se_X_ToScreen(0), se_Y_ToScreen(0),
	     se_X_ToScreen(0), se_Y_ToScreen(460),
	     c);   
    PD_Line (DoubleBuffer,
	     se_X_ToScreen(600), se_Y_ToScreen(0),
	     se_X_ToScreen(0), se_Y_ToScreen(0),
	     c);   
    PD_Line (DoubleBuffer,
	     se_X_ToScreen(6), se_Y_ToScreen(460),
	     se_X_ToScreen(600), se_Y_ToScreen(460),
	     c);   
  }
#endif

  se_CreateGrid();
  


  init_grid_in_process=true;

  ePoint *R=ePoint::InsertIntoGrid(eCoord(0,0));
  R=R->DrawLineTo(eCoord(600,0),  tNEW(gWallRim) (),0);
  R=R->DrawLineTo(eCoord(600,460),tNEW(gWallRim) (),0);
  R=R->DrawLineTo(eCoord(0,460),  tNEW(gWallRim) (),0);
  R=R->DrawLineTo(eCoord(0,0),    tNEW(gWallRim) (),0);
  //  R=R->DrawLineTo(eCoord(600,0),tNEW() gWallRim(),0);

  init_grid_in_process=false;

  /*
  REAL x,y;
  for(x=20;x<600;x+=140){
    ePoint *R=ePoint::InsertIntoGrid(eCoord(x,.1));
    R=R->DrawLineTo(eCoord(x,11),tNEW() gWallRim(false,.1),0);
  }

  for(x=20;x<600;x+=140){
    ePoint *R=ePoint::InsertIntoGrid(eCoord(x,459.9));
    R=R->DrawLineTo(eCoord(x,449),tNEW() gWallRim(false,.1),0);
  }

  for(y=20;y<460;y+=140){
    ePoint *R=ePoint::InsertIntoGrid(eCoord(.1,y));
    R=R->DrawLineTo(eCoord(11,y),tNEW() gWallRim(false,.1),0);
  }

  for(y=20;y<460;y+=140){
    ePoint *R=ePoint::InsertIntoGrid(eCoord(599.9,y));
    R=R->DrawLineTo(eCoord(589,y),tNEW() gWallRim(false,.1),0);
  }
  */

  for(int i=0;i<spawnPoints.Len();i++)
    spawnPoints(i)->Clear();
}

// find the best eSpawnPoint
eSpawnPoint * gArena::LeastDangerousSpawnPoint(){
  REAL mindanger=100;
  eSpawnPoint *ret=NULL;

  for(int i=0;i<spawnPoints.Len();i++)
    if (spawnPoints(i)->Danger()<mindanger){
      ret=spawnPoints(i);
      mindanger=ret->Danger();
    }

  if (!ret)
    tERR_ERROR("No spawnpoint available!");

  return ret;
}
