/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gStuff.h"
#include "tSysTime.h"
#include "rViewport.h"
#include "rConsole.h"
#include "gGame.h"
#include "eSound.h"
#include "rScreen.h"
#include "rSysdep.h"
#include "uInputQueue.h"
#include "eTess.h"
#include "rTexture.h"
#include "tConfiguration.h"
#include "eAdvWall.h"
#include "eGameObject.h"
#include "uMenu.h"
#include "ePlayer.h"
#include <stdio.h>
#include <stdlib.h> 
#include <fstream.h>

#ifndef DEDICATED
#include "rRender.h"
#include <SDL.h>
#endif

#ifdef WIN32
static bool use_directx=false;
static tConfItem<bool> udx("USE_DIRECTX","makes use of the DirectX input "
"fuctions; causes some graphic cards to fail to work (VooDoo 3,...)",
			  use_directx);
#endif

extern void exit_game_objects();

#ifndef DEDICATED
static void welcome(){
  if (st_FirstUse){
    st_FirstUse=false;
    sr_LoadDefaultConfig();
  }
  else
    return;

  sr_UnlockSDL();
  SDL_Event tEvent;
  while((!se_GetSDLInput(tEvent) || tEvent.type!=SDL_KEYDOWN) && 
	tSysTimeFloat()<10){
    
    sr_ResetRenderState(true);
    rViewport::s_viewportFullscreen.Select();
    
    sr_ClearGL();
    
    uMenu::GenericBackground();
    
    REAL w=16*2/640.0;
    REAL h=32*2/480.0;
    
    w/=2;
    h/=2;
    
    //REAL middle=-.6;
    
    Color(1,1,1);
    DisplayText(0,.8,w*2,h*2,"Welcome to ArmageTron!");

    rTextField c(-.8,.6);

    
    c << "Default Settings have been loaded ";
    c << "according to your configuration\n\n";

    c.SetIndent(12);

    c << "GL Vendor  :" << gl_vendor << '\n';
    c << "GL Renderer:" << gl_renderer << '\n';
    c << "GL Version :" << gl_version << '\n';

    c.SetIndent(0);

    c << "\nHave fun!\n";
    
    sr_SwapGL();
  }
  sr_LockSDL();
}
#endif

void cleanup(){
  static bool reentry=true;
  if (reentry){
    reentry=false;
    su_contInput=false;

    exit_game_objects();
    /*
    for(int i=MAX_PLAYERS-1;i>=0;i--){
      if (playerConfig[i])
	destroy(playerConfig[i]->cam);
    }
    
    
    gNetPlayerWall::Clear();

    eFace::Clear();
    eEdge::Clear();
    ePoint::Clear();
    
    eFace::Clear();
    eEdge::Clear();
    ePoint::Clear();
    
    eGameObject::DeleteAll();


    */

#ifdef POWERPAK_DEB
    if (pp_out){
      PD_Quit();
      PP_Quit();     
    }
#endif
    nNetObject::ClearAll();
    
    if (sr_glOut){
      rTexture::UnloadAll();
    }
    
    se_SoundExit();
    sr_glOut=false;
    sr_ExitDisplay();

#ifndef DEDICATED
   rRendererCleanup();
#endif

  }
}

#ifndef DEDICATED
int filter(const SDL_Event *tEvent){
  // boss key
  if (tEvent->type==SDL_KEYDOWN && tEvent->key.keysym.sym==27 &&
      tEvent->key.keysym.mod & KMOD_SHIFT){
    sn_SetNetState(nSTANDALONE);
    sn_Receive();
    st_SaveConfig();
    uMenu::quickexit=true;
    return false;
  }
  
   if(tEvent->type==SDL_MOUSEMOTION)
    if(tEvent->motion.x==sr_screenWidth/2 && tEvent->motion.y==sr_screenHeight/2)
      return 0;
  if (su_mouseGrab && 
      tEvent->type!=SDL_MOUSEBUTTONDOWN &&
      tEvent->type!=SDL_MOUSEBUTTONUP &&
      ((tEvent->motion.x>=sr_screenWidth-10  || tEvent->motion.x<=10) ||
       (tEvent->motion.y>=sr_screenHeight-10 || tEvent->motion.y<=10)))
    SDL_WarpMouse(sr_screenWidth/2,sr_screenHeight/2);

   // fetch alt-tab
  
  if (tEvent->type==SDL_ACTIVEEVENT){
    if (tEvent->active.gain && tEvent->active.state & SDL_APPACTIVE)
      Activate(true);
    if (!tEvent->active.gain && tEvent->active.state & SDL_APPACTIVE)
      Activate(false);
    return false;
  }

  if (su_prefetchInput){
    return se_StoreSDLEvent(*tEvent);
  }

  return 1;
}
#endif



//from game.C
void host_game();
void connect_to_server();
void Update_netPlayer();

int main(int argc,char **argv){
  //cout << "enter\n";
  //  net_test();

  //  cout << "Running " << argv[0] << "...\n";

  st_LoadConfig();

  //cout << "config loaded\n";

#ifndef DEDICATED
  sr_glOut=1;

  for(int i=0;i<argc;i++){
    if (!strcmp(argv[i],"-fullscreen")){
      currentScreensetting.fullscreen=true;
    }
    if (!strcmp(argv[i],"-window") || !strcmp(argv[i],"-windowed")){
      currentScreensetting.fullscreen=false;
    }

#ifdef WIN32
    if (!strcmp(argv[i],"+directx")){
      use_directx=true;
    }
    if (!strcmp(argv[i],"-directx")){
      use_directx=false;
    }
#endif

#ifdef POWERPAK_DEB
    if (!strcmp(argv[i],"nodeb")){
      pp_out=0;
    }
#endif
  }

  {
#ifndef WIN32
   ifstream t("armagetron");
#else
   ifstream t("armagetron.exe");
#endif
if (!t.good())
      tERR_ERROR("\n\nYou are not running Armagetron from it's own directory.\n" <<
		 "That way, it would not be able to find all it's files and\n" <<
		 "it would block your computer. Exiting now...\n\n");
  }

  {
    ifstream t("moviepack/settings.cfg");

    if (t.good())
      sg_moviepackInstalled=true;
  }

  {
    ifstream t("moviepack");

    char c;
    while (!t.eof() && t.good()){
      t.get(c);
      cout.put(c);
    }
  }

  //cout << "checked mp\n";

  // while DGA mouse is buggy in XFree 4.0:
#ifdef linux
  // Sam 5/23 - Don't ever use DGA, we don't need it for this game.
  if ( ! getenv("SDL_VIDEO_X11_DGAMOUSE") ) {
   putenv("SDL_VIDEO_X11_DGAMOUSE=0");
  }
#endif

#ifdef WIN32
  // disable DirectX by default; it causes problems with some boards.
  if (!use_directx && !getenv("SDL_VIDEODRIVER") ) {
    putenv("SDL_VIDEODRIVER=windib");
  }
#endif

  if ( SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0
       && SDL_Init(SDL_INIT_VIDEO) < 0 )
    tERR_ERROR("Couldn't initialize SDL: " << SDL_GetError());

  glRendererInit();

  SDL_SetEventFilter(&filter);

  //cout << "set filter\n";

  rTexture::SetIcon();

  if (sr_InitDisplay()){

    //cout << "init disp\n";
    
    se_SoundInit();
#ifndef DEBUG
    se_SoundExit();
    se_SoundInit();
#endif
    
    //cout << "init sound\n";
    
    welcome();
    
    atexit(SDL_Quit); 
    
    //cout << "atexit\n";
    
    sr_con.autoDisplayAtSwap=false;
    
    se_SoundPause(false);
    
    //cout << "sound started\n";
    
    MainMenu();
    
    //cout << "exit\n";
    
    st_SaveConfig();
    
    //cout << "saved\n";
    
    cleanup();
  }
#else
  sr_Unblock_stdin();
  sr_glOut=0;
  
  if (argc<2)
    while (!uMenu::quickexit)
      host_game();
  else{
    sr_glOut=1;
    ePlayerNetID::Update();
    connect_to_server();
  }
#endif

  nNetObject::ClearAll();

  return 0;
}



