/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_CYCLE_H
#define ArmageTron_CYCLE_H

#include "gStuff.h"
#include "eSound.h"
//#include "rTexture.h"
//#include "rModel.h"
#include "eNetGameObject.h"
class rModel;
class gTextureCycle;

// this class describes a point on the map the cycle on another
// computer of the game IS at. The copies of the cycle on the
// other computers try to reach this position by making the right
// turns.
class gDestination{
  friend class gCycle;
  
  eCoord position;
  eCoord direction;
  REAL  gameTime;
  REAL  distance;
  REAL  speed;
  bool  braking;

  bool hasBeenUsed;

  gDestination *next; // so they can form a list
  gDestination **list; // the list we are in
 public:
  // take pos,dir and time from a cycle
  gDestination(const gCycle &takeitfrom);
  // or from a message
  gDestination(nMessage &m);
  
  // write all the data into a nMessage
  void WriteCreate(nMessage &m);

  // insert yourself into a list ordered by distance
  void InsertIntoList(gDestination **list);
  
  // find the latest entry in a list before the given distance
  static gDestination *RightBefore(gDestination *list, REAL dist);

  // remove yourself again
  void RemoveFromList();

  ~gDestination(){RemoveFromList();}
};

class gCycle: public eNetGameObject{ // a lightcycle
  friend class gPlayerWall;
  friend class gNetPlayerWall;
  friend class gDestination;

  eSoundPlayer engine;
  eSoundPlayer turning;

  REAL lastTimeAnim;

  REAL nextChatAI;

  eCoord correctPosSmooth;

  gDestination *destinationList;
  gDestination *currentDestination;
public:
  eCoord dirDrive;              // the direction we are facing in reality
  REAL skew,skewDot,speed,acceleration; // leaning to the side and velocity
  REAL rubber;    // allows stopping shortly if there's a eWall ahead
private:
  bool mp; // use moviepack or not?

  rModel *body,*front,*rear,
    *customModel;
  
  gTextureCycle  *wheelTex,*bodyTex;
  gTextureCycle  *customTexture;

  eCoord rotationFrontWheel,rotationRearWheel;  // wheel position (rotation)
  REAL   heightFrontWheel,heightRearWheel;  // wheel (suspension)

  REAL nextTurn;
  int  pendingTurns;
  
  unsigned short turns; // how many turns did we make up to now?

  unsigned short braking;
public:
  static uActionPlayer s_brake;
  short alive; // are we still there?
  
  REAL  r,g,b; // color

  REAL  distance; //distance travveled so far

  // smooth corrections for space-based network control
  REAL correctTimeSmooth,correctSpeedSmooth,correctDistSmooth;

private:

  tCHECKED_PTR(gNetPlayerWall) currentWall;
                            // the eWall we are currently making
  tCHECKED_PTR(gNetPlayerWall) lastWall;

  unsigned short currentWallID;

  REAL nextSync;

  void MyInitAfterCreation();

  static void Hunt(gCycle *hunter, gCycle *prey);

  void SetCurrentWall(gNetPlayerWall *w);
protected:
  virtual ~gCycle();
public:
  virtual bool EdgeIsDangerous(const eEdge *e, REAL time, REAL a);

  virtual void InitAfterCreation(); 
  gCycle(const eCoord &pos,const eCoord &dir,ePlayerNetID *p=NULL,bool autodelete=1);

  // the network routines:
  gCycle(nMessage &m);
  virtual void WriteCreate(nMessage &m);
  virtual void WriteSync(nMessage &m);
  virtual void ReadSync(nMessage &m);
  virtual void ReceiveControl(REAL time,uActionPlayer *Act,REAL x);

  void AddDestination(gDestination *dest);

  void AddDestination(){
    AddDestination(new gDestination(*this));
  }

  virtual nDescriptor &CreatorDescriptor() const;
  virtual bool SyncIsNew(nMessage &m);
  //virtual bool ClearToTransmit(int user) const;

  virtual eCoord Direction()const{return dirDrive;}

  //  virtual gameobject_type type();

  virtual bool Timestep(REAL currentTime); 
  bool TimestepCore(REAL currentTime); 

  virtual void InteractWith(eGameObject *target,REAL time,int recursion=1);

  virtual void PassEdge(const eEdge *e,REAL time,REAL a,int recursion=1);

  virtual bool Act(uActionPlayer *Act,REAL x);

  void Turn(REAL dir);
  void Turn(int dir);

  void Turbo(bool turbo);
  
  virtual void Kill();

  virtual bool Alive(){return alive>=1;}
  
  const eEdge* Edge();
  const gPlayerWall* CurrentWall();
  const gPlayerWall* LastWall();

#ifndef DEDICATED
  virtual void Render();

  virtual bool RenderCockpitFixedBefore(bool primary=true);   

  virtual void SoundMix(Uint8 *dest,unsigned int len,
			int viewer,REAL rvol,REAL lvol); 
#endif

  virtual eCoord CamPos();
  virtual eCoord PredictPosition(); 

  virtual eCoord  CamTop();

#ifdef POWERPAK_DEB
  virtual void PPDisplay();
#endif

};

#endif
