/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gExplosion.h"
#include "rModel.h"
#include "rRender.h"
#include "tInitExit.h"

static eWavData explode("moviesounds/dietron.wav","sound/expl.wav");

gExplosion::gExplosion(const eCoord &pos,REAL time,REAL R,REAL G,REAL B)
  :eGameObject(pos,eCoord(0,0),true),
   sound(explode),
   createTime(time),
   r(R),g(G),b(B)
{
  sound.Reset();
}

gExplosion::~gExplosion(){}

  // virtual eGameObject_type type();

bool gExplosion::Timestep(REAL currentTime){
  lastTime=currentTime;
  if (currentTime>createTime+4)
    return true;
  else
    return false;
}

void gExplosion::InteractWith(eGameObject *,REAL ,int){}

void gExplosion::PassEdge(eEdge *,REAL ,REAL ,int){}

void gExplosion::Kill(){createTime=lastTime-100;}



static tArray<Vec3> expvec;

static void init_exp(){
  int i=0;
  expvec[i++]=Vec3(0,0,1);
  expvec[i++]=Vec3(0,1,1);
  expvec[i++]=Vec3(0,-1,1);
  expvec[i++]=Vec3(1,0,1);
  expvec[i++]=Vec3(-1,0,1);
  expvec[i++]=Vec3(1,1,1);
  expvec[i++]=Vec3(-1,1,1);
  expvec[i++]=Vec3(1,-1,1);
  expvec[i++]=Vec3(-1,-1,1);

  const REAL fak=7;

  for(int j=i;j<40;j++){
    expvec[i++]=Vec3(fak*(rand()/(REAL)RAND_MAX-.5),
			 fak*(rand()/(REAL)RAND_MAX-.5),
			 1);
  }

  for(int k=expvec.Len()-1;k>=0;k--)
    expvec[k]=expvec[k]*(1/expvec[k].Norm());
}

static tInitExit ie_exp(&init_exp);

#ifndef DEDICATED
void gExplosion::Render(){
  REAL a1=(lastTime-createTime)+.2;
  REAL e=a1-1;

  if (e<0) e=0;

  REAL fade=(2-a1);
  if (fade<0) fade=0;
  if (fade>1) fade=1;

  a1*=100;
  e*=100;

  ModelMatrix();
  glPushMatrix();
  glTranslatef(pos.x,pos.y,0);
  
  //glDisable(GL_TEXTURE);
  glDisable(GL_TEXTURE_2D);

  glColor4f(1,1,1,fade);
  BeginLines();
  for(int i=expvec.Len()-1;i>=0;i--){
    glVertex3f(a1*expvec[i].x[0],a1*expvec[i].x[1],a1*expvec[i].x[2]);
    glVertex3f( e*expvec[i].x[0], e*expvec[i].x[1], e*expvec[i].x[2]);
  }
  RenderEnd();
  glPopMatrix();

  /*
  if(sr_alphaBlend)
    for(int i=2;i>=0;i--){
      REAL age=a1-i*.1;
      if (0<age && age<.5){
	REAL alpha=(3-i)*.5*(1-age*2)*(1-age*2);
	glColor4f(r,g,b,alpha);
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glTranslatef(pos.x,pos.y,age*pow((age+1),3)*(age+.5)*100);
y	
	
	GLUquadricObj* q= gluNewQuadric();
	
	gluSphere(q,(age*pow((age+1),3)*(age+.5))*100,5,5);
	
	gluDeleteQuadric( q );
	
	glPopMatrix();
      }
    }
  */
}

void gExplosion::SoundMix(Uint8 *dest,unsigned int len,
		      int viewer,REAL rvol,REAL lvol){
  sound.Mix(dest,len,viewer,rvol*4,lvol*4);
}
#endif

