/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "nNet.h"
#include "gStuff.h"
#include "eSound.h"
#include "tSysTime.h"
#include "gGame.h"
#include "eTess.h"
#include "rTexture.h"
#include "gWall.h"
#include "rConsole.h"
#include "gCycle.h"
#include "eCoord.h"
#include "eTimer.h"
#include "gAIBase.h"
#include "rSysdep.h"
#include "rFont.h"
#include "uMenu.h"
#include "nConfig.h"
#include "rScreen.h"
#include "rViewport.h"
#include "uInput.h"
#include "ePlayer.h"
#include "gArena.h"
#include "eSpawn.h"
#include "uInput.h"
#include "uInputQueue.h"
#include "nNetObject.h"
#include "tToDo.h"
#include "gMenus.h"
#include "gCamera.h"

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <ctype.h>

#ifndef DEDICATED
#include <SDL.h>
#include <SDL_thread.h>

#ifdef DEBUG
#ifndef WIN32
//#include <GL/xmesa.h>

//static bool fullscreen=1;
#endif
#endif
#endif

static REAL ded_idle=0;
static tSettingItem<REAL> dedicaded_idle("DEDICATED_IDLE",
"after running this time (in hours), the dedicated server takes the" 
" next chance to quit.",ded_idle);

static int this_score_win,limitTimeThis,this_limit_rounds,
  this_limit_score,this_ais;

static eWavData intro("moviesounds/intro.wav");
static eWavData extro("moviesounds/extro.wav");

static int score_win=10;
static tSettingItem<int> s_w("SCORE_WIN","you get that when you win a round",score_win);

static int limitTime=30;
static tSettingItem<int> l_t("LIMIT_TIME","Match time limit in minutes",limitTime);

static int limit_rounds=10;
static tSettingItem<int> l_r("LIMIT_ROUNDS","Match round limit",limit_rounds);

static int limit_score=100;
static tSettingItem<int> l_s("LIMIT_SCORE","Match score limit",limit_score);

static int sp_score_win=10;
static tSettingItem<int> sp_s_w("SP_SCORE_WIN","You get this when you"
" win a match in the single player highscore hunt",sp_score_win);

static int sp_limitTime=30;
static tSettingItem<int> sp_l_t("SP_LIMIT_TIME","Time limit for "
"single player highscore hunt",sp_limitTime);

static int sp_limit_rounds=10;
static tSettingItem<int> sp_l_r("SP_LIMIT_ROUNDS",
"round limit for single player highscore hunt",
sp_limit_rounds);

static int sp_limit_score=10000;
static tSettingItem<int> sp_l_s("SP_LIMIT_SCORE",
"score limit for single player highscore hunt (hmm. quite useless)",
sp_limit_score);

static int sp_ais=6;
static tSettingItem<int> sp_aisc("SP_AIS","number of opponents"
" in single player highscore hunt",sp_ais);



class gHighscoresBase{
  int id;
  static List<gHighscoresBase> highscoreList;
protected:
  tArray<tString> highName;

  char *highscore_file;
  char *desc;
  int maxSize;

  // find the player at position i
  ePlayerNetID *online(int p){
    for (int i=se_PlayerNetIDs.Len()-1;i>=0;i--)
      if (!strcmp(se_PlayerNetIDs(i)->name,highName[p]))
	return se_PlayerNetIDs(i);

    return NULL;
  }

  virtual void swap_entries(int i,int j){
    Swap(highName[i],highName[j]);

    // send the poor guy who just dropped a message
    ePlayerNetID *p=online(i);
    if (p){
      tString message;
      message << *p << ColorString(1,.5,.5);
      
      if (i>j)
	message<<  " dropped to place " ;
      else
	message<<  " rose to place " ;
      
      message << i+1 << " on the " 
	      << desc << " because of " << highName[j] << ".\n";
      sn_ConsoleOut(message,p->Owner());
      // con << message;
    }
  }

  void load_Name(istream &s,int i){
    char c=' ';
    while (s.good() && !s.eof() && isspace(c))
      s.get(c);
    s.putback(c);
    
    highName[i].ReadLine(s);
  }

  void save_Name(ostream &s,int i){
    s << highName[i];
  }


 public:

  virtual void Save()=0;
  virtual void Load()=0;

  // returns if i should stay above j
  virtual bool inorder(int i,int j)=0;

  void sort(){
    // since single score items travel up the
    // score ladder, this is the most efficient sort algorithm:

    for(int i=1;i<highName.Len();i++)
      for(int j=i;j>=1 && !inorder(j-1,j);j--)
	swap_entries(j,j-1);
  }

  
  int checkPos(int found){
    // move him up
    int newpos=found;
    while(newpos>0 && !inorder(newpos-1,newpos)){
      swap_entries(newpos,newpos-1);
      newpos--;
    }

    // move him down
    while(newpos<highName.Len()-1 && !inorder(newpos,newpos+1)){
      swap_entries(newpos,newpos+1);
      newpos++;
    }
    
    //Save();
    
    return newpos;
  }

  int Find(const char *name,bool force=false){
    int found=highName.Len();
    for(int i=found-1;i>=0 ;i--)
      if(highName[i].Len()<=1 || !strcmp(highName[i],name)){
	found=i;
      }

    if (force && highName[found].Len()<=1)
      highName[found]=name;

    return found;
  }

  gHighscoresBase(char *name,char *sd,int max=0)
    :id(-1),highscore_file(name),desc(sd),maxSize(max){
    highscoreList.Add(this,id);
  }

  virtual ~gHighscoresBase(){
    highscoreList.Remove(this,id);
  }

  virtual void greet_this(ePlayerNetID *p,tString &s){
    int f=Find(p->name)+1;
    int l=highName.Len();
    if (l>=f)
      s << "number " << f << " of " << l
	<< " on the " << desc;
    else
      s << "not on the " << desc;
  }

  static void Greet(ePlayerNetID *p,tString &s){
    s << "You are ";
    for(int i=highscoreList.Len()-1;i>=0;i--){
      highscoreList(i)->greet_this(p,s);
      if (i>1)
	s << ", ";
      if (i==1)
	s << " and ";
    }
    s << ".\n";
  }

  static void SaveAll(){
    for(int i=highscoreList.Len()-1;i>=0;i--)
      highscoreList(i)->Save();
  }
};

void ePlayerNetID::GreetHighscores(tString &s){
  gHighscoresBase::Greet(this,s);
}


List<gHighscoresBase> gHighscoresBase::highscoreList;

template<class T>class highscores: public gHighscoresBase{
protected:
  tArray<T>    high_score;

  virtual void swap_entries(int i,int j){
    Swap(high_score[i],high_score[j]);
    gHighscoresBase::swap_entries(i,j);
  }

public:
  virtual void Load(){
    ifstream s(highscore_file);
    if (s.good()){
      int i=0;
      while (s.good() && !s.eof()){
	s >> high_score[i];
	load_Name(s,i);
	// con << highName[i] << " " << high_score[i] << '\n';
	i++;
      }
    }
  }
  
  // returns if i should stay above j
  virtual bool inorder(int i,int j){
    return (highName[j].Len()<=1 || high_score[i]>=high_score[j]);
  }

 
  virtual void Save(){
    sort();
    ofstream s(highscore_file);
    if (s.good()){
      int i=0;
      int max=high_score.Len();
      if (maxSize && max>maxSize)
	max=maxSize;
      while (highName[i].Len()>1 && i<max){
	tString mess;
	mess << high_score[i];
	mess.SetPos(10);
	s << mess;
	save_Name(s,i);
	s << '\n';
	i++;
	//cout << mess;
	//save_Name(cout,i);
	//cout << '\n';
      }
    }
  }
  
  void checkPos(int found,const tString &name,T score){
    tString message;
    // find the name in the list
    bool isnew=false;
    if (highName[found].Len()<=1){
      highName[found]=name;
      message << name << " entered the " << desc << " list with " << score 
	      << " points ";
      high_score[found]=score;
      isnew=true;
    }		    
    else if (score>high_score[found]){
      message << name << " improved its personal highscore in the "
	      << desc << " to " << score << ' ';
      high_score[found]=score;
    }
    else
      return;
    
    // move him up
    int newpos=gHighscoresBase::checkPos(found);

    if (newpos!=found || isnew)
      if (newpos==0)
	message << "and moved to the top!\n";
      else
	message << "and moved to position " << newpos+1 << ".\n";
    else
      if (newpos==0)
	message << "and stayed at the top.\n";
      else
	message << "but stayed at position " << newpos+1 << ".\n";
    
    ePlayerNetID *p=online(newpos);
    //con << message;
    if (p)
      sn_ConsoleOut(message,p->Owner());
    //Save();
  }
  
  void Add(const tString &name,T AddScore){
    int f=Find(name,true);
    checkPos(f,name,AddScore+high_score[f]);
  }

  void Check(const tString &name,T score){
    int len = high_score.Len();
    if (len<=0 || score>high_score[len-1]){
      // find the name in the list
      int found=Find(name,true);
      checkPos(found,name,score);
    }
  }


  highscores(char *name,char *sd,int max=0)
    :gHighscoresBase(name,sd,max){
    Load();
  }

  virtual ~highscores(){
    Save();
  }
};



static REAL ladder_min_bet=1;
static tSettingItem<REAL> ldd_mb("LADDER_MIN_BET",
				 "minimum score you put in the ladder pot",
				 ladder_min_bet);

static REAL ladder_perc_bet=10;
static tSettingItem<REAL> ldd_pb("LADDER_PERCENT_BET",
				 "percentage of your score you put in the ladder pot",ladder_perc_bet);

static REAL ladder_tax=1;
static tSettingItem<REAL> ldd_tex("LADDER_TAX","percentage of the ladder pot the IRS takes",
				  ladder_tax);

static REAL ladder_loose_perc_on_load=.2;
static tSettingItem<REAL> ldd_lpl("LADDER_LOOSE_PERCENT_ON_LOAD",
				  "percentage of your ladder score lost "
				  "on each load",
				  ladder_loose_perc_on_load);

static REAL ladder_loose_min_on_load=.2;
static tSettingItem<REAL> ldd_lml("LADDER_LOOSE_MIN_ON_LOAD",
				  "minimum of you ladder score lost on "
				  "each load",
				  ladder_loose_min_on_load);

static REAL ladder_gain_extra=1;
static tSettingItem<REAL> ldd_ga("LADDER_GAIN_EXTRA",
				 "ping dependent ladder extra score for the winner",
				 ladder_gain_extra);


class ladder: public highscores<REAL>{
 public:
  virtual void Load(){
    highscores<REAL>::Load();

    sort();

    int end=highName.Len();
    
    for(int i=highName.Len()-1;i>=0;i--){

      // make them loose some points

      REAL loss=ladder_loose_perc_on_load*high_score[i]*.01;
      if (loss<ladder_loose_min_on_load)
	loss=ladder_loose_min_on_load;
      high_score[i]-=loss;

      if (high_score[i]<0)
	end=i;
    }

    // remove the bugggers with less than 0 points
    highName.SetLen(end);
    high_score.SetLen(end);
  }
  
  void checkPos(int found,const tString &name,REAL score){
    tString message;
    // find the name in the list
    bool isnew=false;
    if (highName[found].Len()<=1){
      highName[found]=name;
      message << name << " entered the " << desc << " list with " << score 
	      << " points ";
      high_score[found]=score;
      isnew=true;
    }		    
    else{
      REAL diff=score-high_score[found];
      if (diff>0)
	message << name << " gained " << diff << " points on the "
		<< desc << ' ';
      else
	message << name << " lost " << -diff << " points on the "
		<< desc << ' ';
      
      high_score[found]=score;
    }
    
    // move him up
    int newpos=gHighscoresBase::checkPos(found);

    if (newpos!=found || isnew)
      if (newpos==0)
	message << "and moved to the top of the list!\n";
      else
	message << "and moved to position " << newpos+1 << ".\n";
    else
      if (newpos==0)
	message << "and stayed at the top of the list.\n";
      else
	message << "but stayed at position " << newpos+1 << ".\n";
    
    ePlayerNetID *p=online(newpos);
    // con << message;
    if (p){
      sn_ConsoleOut(message,p->Owner());
    }

    // Save();
  }

  void Add(const tString &name,REAL AddScore){
    int found=Find(name,true);
    checkPos(found,name,AddScore+high_score[found]);
  }

  // ladder mechanics: what happens if someone wins?
  void winner(int win){
    // only do something in multiplayer mode
    int i;
    int count=0;
    for(i=se_PlayerNetIDs.Len()-1;i>=0;i--)
      if (se_PlayerNetIDs(i)->Object())
	count++;
    // count the really active players
    

    if (se_PlayerNetIDs.Len()>1 && 0<=win && win<se_PlayerNetIDs.Len() 
	&& count>1){
      tArray<int> nums;
      tArray<REAL> bet;

      REAL pot=0;

      for(i=se_PlayerNetIDs.Len()-1;i>=0;i--){

	nums[i]=Find(se_PlayerNetIDs(i)->name,true);

	if (high_score[nums[i]]<0)
	  high_score[nums[i]]=0;

	if (se_PlayerNetIDs(i)->Object()){
	  bet[i]=high_score[nums[i]]*ladder_perc_bet*.01;
	  if (bet[i]<ladder_min_bet)
	    bet[i]=ladder_min_bet;
	  pot+=bet[i];
	}
	else
	  bet[i]=0;
      }
      
      pot-=pot*ladder_tax*.01; // you have to pay to the bank :-)
      
      // now bet[i] tells us how much player nums[i] has betted
      // and pot is the overall bet. Add something to it, prop to
      // the winners ping+ping charity:

      REAL pc=se_PlayerNetIDs(win)->ping+se_PlayerNetIDs(win)->pingCharity*.001;
      if (pc<0)
	pc=0;
      if (pc>1) // add sensible bounds
	pc=1;

      pot+=pc*ladder_gain_extra;

      // take the bet from the loosers and give it to the winner
      for(i=se_PlayerNetIDs.Len()-1;i>=0;i--)
	if(i==win)
	  Add(se_PlayerNetIDs(i)->name, pot-bet[i]);
	else if (se_PlayerNetIDs(i)->Object())
	  Add(se_PlayerNetIDs(i)->name,-bet[i]);
    }
  }

  ladder(char *name,char *sd,int max=0)
    :highscores<REAL>(name,sd,max){
    Load();
  }

  virtual ~ladder(){
    Save();
  }
};


static highscores<int> highscore("highscores.txt","singe player highscores",100);
static highscores<int> highscore_won_rounds("won_rounds.txt",
					    "won multiplayer rounds list");
static highscores<int> highscore_won_matches("won_matches.txt",
					     "won multiplayer matches list");
static ladder highscore_ladder("ladder.txt",
			       "ladder");


#define PREPARE_TIME 4

static bool just_connected=true;
static bool sg_singlePlayer=0;
static int winner=0;
static int absolute_winner=0;
static REAL lastTime_gameloop=0;
static REAL lastTimeTimestep=0;
  

void check_hs(){
  if (sg_singlePlayer)
    if(se_PlayerNetIDs.Len()>0)
      highscore.Check(se_PlayerNetIDs(0)->name,se_PlayerNetIDs(0)->Score());
}


static tCONTROLLED_PTR(gGame) sg_currentGame;

static gCycle *ePlayer(int id){
  eGameObject *object=NULL;
  for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--)
    if (se_PlayerNetIDs[i]->pID==id && se_PlayerNetIDs[i]->Object())
      object=se_PlayerNetIDs[i]->Object();

  return (gCycle *)(object);
}

#ifdef POWERPAK_DEB
#include "PowerPak/poweruInput.h"
#include "PowerPak/joystick.h"
#endif

#include "rRender.h"

gArena Arena;

#define MAXAI 20
static int ais=1;
static tConfItem<int> num_ai("NUM_AIS","number of AI players",ais);
gAIPlayer *ai[MAXAI];

static bool auto_ai=true;

static tConfItem<bool> auto_num_ai("AUTO_AIS","automatically change the number of AI players",auto_ai);


#define AUTO_AI_MAXFRAC 6
#define AUTO_AI_WIN     2
#define AUTO_AI_LOOSE   3

static int  auto_ai_fraction=AUTO_AI_MAXFRAC >> 1;

void AutoAI(bool success){
  if (!auto_ai)
    return;

  if (success)
    {
      auto_ai_fraction += AUTO_AI_WIN;
      while (auto_ai_fraction > AUTO_AI_MAXFRAC)
	{
	  auto_ai_fraction -= AUTO_AI_MAXFRAC;
	  if (ais < MAXAI) ais++;
	}
    }
  else
    {
      auto_ai_fraction -= AUTO_AI_LOOSE;
      while (auto_ai_fraction < 0)
	{
	  auto_ai_fraction += AUTO_AI_MAXFRAC;
	  if (ais >= 2) ais--;
	}
    }
}


gGameType sg_gameType=gDUEL;

static tConfItem<int> gt("GAME_TYPE","type of game",(int &)sg_gameType);


gFinishType sg_finishType=gFINISH_IMMEDIATELY;

static tConfItem<int> ft("FINISH_TYPE","finish fast or slow?",(int &)sg_finishType);

void exit_game_grid(){
  se_ClearGrid();
}

void exit_game_objects(){
  sr_con.fullscreen=true;
  
  su_prefetchInput=false;

  int i;
  for(i=ePlayer::Num()-1;i>=0;i--){
    if (ePlayer::PlayerConfig(i))
      tDESTROY(ePlayer::PlayerConfig(i)->cam);
  }

  for(i=MAXAI-1;i>=0;i--)
    if (ai[i])
      ai[i]->ClearTarget();
  
  gNetPlayerWall::Clear();

  exit_game_grid();


  for(i=MAXAI-1;i>=0;i--)
    tDESTROY_PTR(ai[i]);

  if (sn_GetNetState()!=nCLIENT)
    for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--)
      if(se_PlayerNetIDs(i))
	se_PlayerNetIDs(i)->ClearObject();


  eGameObject::DeleteAll();
  
  for(int k=this_ais-1;k>=0;k--)
    ai[k]=NULL;
}

void init_game_grid(){
#ifndef DEDICATED
  if (sr_glOut){
    sr_ResetRenderState();
    
    sr_ClearGL();
    
    glViewport (0, 0, (GLsizei) sr_screenWidth, (GLsizei) sr_screenHeight);
    
    glFinish();
    sr_SwapGL();
  }
#endif
  /*
    if(!speedup)
    SDL_Delay(1000);
  */   

  Arena.PrepareGrid();

  absolute_winner=winner=0;
  
  se_ResetGameTimer();
  se_PauseGameTimer(true);
}

void init_game_objects(){
/*
  static REAL r[MAX_PLAYERS]={1,.2,.2,1};
  static REAL g[MAX_PLAYERS]={.2,1,.2,1};
  static REAL b[MAX_PLAYERS]={.2,.2,1,.2};
*/
  eSpawnPoint *spawn=Arena.LeastDangerousSpawnPoint();
  for(int p=se_PlayerNetIDs.Len()-1;p>=0;p--){
    eCoord pos,dir;
    if (sn_GetNetState()!=nCLIENT){
#ifdef DEBUG
      //con << "spawning player " << se_PlayerNetIDs[p]->name << '\n';
#endif
      spawn->Spawn(pos,dir);
      se_PlayerNetIDs(p)->Greet();
      se_PlayerNetIDs(p)->ControlObject(new gCycle(pos,dir,
						  se_PlayerNetIDs(p),0));
      nNetObject::SyncAll();
    }
    int i=se_PlayerNetIDs(p)->pID;

    se_ResetGameTimer();
    se_PauseGameTimer(true);

    if (sg_gameType==gHUMAN_VS_AI){
      if (ePlayer(p))
	ePlayer(p)->team=1;
    }
    else{
#ifdef DEBUG
      //con << "new eSpawnPoint.\n";
#endif
      spawn=Arena.LeastDangerousSpawnPoint();
      if (ePlayer(p))
	ePlayer(p)->team=i+1;
    }
  }
  
  spawn=Arena.LeastDangerousSpawnPoint();

  /*
  static REAL rgb[MAXAI][3]={
    {1,1,.2},
    {1,.2,1},
    {.2,1,1},
    {1,.6,.2},      
    {.2,1,.6},      
    {.6,.2,1},      
    {1,.2,.6},      
    {.6,1,.2},      
    {1,1,1},      
    {.2,.2,.2}       
  };
  */

  if (sn_GetNetState()!=nCLIENT)
    for(int i=this_ais-1;i>=0;i--){
      eCoord pos,dir;
      spawn->Spawn(pos,dir);
      ai[i]=new gAIPlayer(new gCycle(pos,dir,NULL,0));
      ai[i]->Object()->team=-1;
      
      //if (sg_gameType!=gHUMAN_VS_AI)
      spawn=Arena.LeastDangerousSpawnPoint();
    }

  rTexture::LoadAll();
  se_ResetGameTimer();
  se_PauseGameTimer(true);

  su_prefetchInput=true;

  lastTime_gameloop=lastTimeTimestep=0;
}

void init_game_camera(){
#ifndef DEDICATED
  for(int i=ePlayer::Num()-1;i>=0;i--)
    if (ePlayer::PlayerIsInGame(i)){
      ePlayerNetID *p=ePlayer::PlayerConfig(i)->netPlayer;
      
      if (sg_finishType==gFINISH_EXPRESS)
	se_ResetGameTimer(-PREPARE_TIME/5);
      else
	se_ResetGameTimer(-PREPARE_TIME);

      se_PauseGameTimer(true);

      ePlayer::PlayerConfig(i)->cam=new gCamera(ePlayer::PlayerViewport(i),
						    p,
						    ePlayer::PlayerConfig(i),
						    CAMERA_SMART);
      
      lastTime_gameloop=lastTimeTimestep=0;
    }
#endif
  /*
  for(int p=se_PlayerNetIDs.Len()-1;p>=0;p--){
    int i=se_PlayerNetIDs(p)->pID;

    se_ResetGameTimer(-PREPARE_TIME);
    se_PauseGameTimer(true);

    if (i>=0)
      playerConfig[i]->cam=new eCamera(PlayerViewport(i),
				       se_PlayerNetIDs(p),CAMERA_SMART);
				       }

*/
}

bool think=1;


void s_Timestep(REAL time,bool cam){
  gNetPlayerWall::s_CopyIntoGrid();
  se_SoundLock();
  eGameObject::s_Timestep(time);

    //if (cam)
  eCamera::s_Timestep(time);
  se_SoundUnlock();

  lastTimeTimestep=time;
}

#ifndef DEDICATED
void RenderAllViewports(){
  rViewportConfiguration *conf=rViewportConfiguration::CurrentViewportConfiguration();
 
  if(sr_glOut){
    sr_ResetRenderState();
 
    for(int i=NumberOfCameras()-1;i>=0;i--){
      int p=sr_viewportBelongsToPlayer[i];
      conf->Select(i);
      rViewport *act=conf->Port(i);
      if (act && ePlayer::PlayerConfig(p))
        ePlayer::PlayerConfig(p)->Render();
      else con << "hey! viewport " << i << " does not exist!\n";
    }
 
  }
 
#ifdef POWERPAK_DEB
  if (pp_out){
    eGameObject::PPDisplayAll();
    PD_ShowDoubleBuffer();
  }
#endif
}
#endif
  

void Render(REAL time,bool swap=true){
#ifdef DEBUG
  eFace::UpdateVisAll(10);
#endif
  se_debugExt=0;

#ifndef DEDICATED
  if (sr_glOut){
    RenderAllViewports();
    
    if (swap){
      sr_SwapGL();
      
      if(!sr_ZTrick || 
	 (!sr_highRim && !sr_lowerSky && !sr_upperSky) || 
	 sr_floorDetail<rFLOOR_TEXTURE || 
	 sr_floorMirror==rMIRROR_OBJECTS){
	sr_ClearGL();
      }
    }
  }
  else
    SDL_Delay(50);
#endif
}

#ifdef DEDICATED
static void cp(){
  ofstream s("players.txt");
  if (s.good()){
    if (se_PlayerNetIDs.Len()>0)
      s << RemoveColors(ePlayerNetID::Ranking());
    else{
      int count=0;
      for(int i=MAXCLIENTS;i>0;i--)
	if (sn_sockets[i]>0)
	  count++;
      if (count==0)
	s << "Nobody online.\n";
      else if (count==1)
	s << " One user online in spectator mode.\n";
      else
	s << count << " users online in spectator mode.\n";
    }
  }
}
#endif


static void own_game(){
  new gGame;
  se_MakeGameTimer();
  EnterGame();
  sg_currentGame=NULL;
  se_KillGameTimer();
}

static void singlePlayer_game(){
  sn_SetNetState(nSTANDALONE);
  own_game();
}


void host_game(){
  sn_SetNetState(nSERVER);

#ifdef DEDICATED
  static double endTimeout=-1;
  if (endTimeout<0)
    endTimeout=tSysTimeFloat()+ded_idle*3600;

  if (se_PlayerNetIDs.Len() == 0)
    {
      cp();
      con << "Nobody there. Taking a nap...\n";
  
      int counter = -1;

      while(se_PlayerNetIDs.Len()==0 && 
	    (ded_idle<.0001 || tSysTimeFloat()<endTimeout)){
	sr_Read_stdin();
	gGame::NetSyncIdle();
	usleep(100000);
	
	if (counter <= 0)
	  {
	    // restart network, just in case we lost the input socket
	    ANET_Listen(false);
	    ANET_Listen(true);
	    counter = 50;
	  }
      }
      
      if (se_PlayerNetIDs.Len()==0 && ded_idle>0.0001 && 
	  tSysTimeFloat()>=endTimeout){
	uMenu::quickexit = true;
      }
    }
  cp();

  if (!uMenu::quickexit)
#endif
    own_game();

  sn_SetNetState(nSTANDALONE);
}


//static tString servername="129.206.119.46";
//static tString servername="www.gartenhaus.net";
static tString sn_serverName="";
static tConfItemLine sn_serverName_ci("SERVER_NAME","name of the server to connect to",sn_serverName);



void connect_to_server(){
  sn_bigBrotherString = renderer_identification;

  just_connected=true;
  ePlayerNetID::Update();

#ifndef DEDICATED
  sr_SwapGL();
  sr_ClearGL();
  sr_SwapGL();
  sr_ClearGL();
#endif

  sr_con.autoDisplayAtNewline=true;
  sr_con.fullscreen=true;

  bool to=sr_textOut;
  sr_textOut=true;
  con << "connecting to server " << sn_serverName << " ...\n";
  sn_Connect(sn_serverName);
  

  if (sn_GetNetState()==nCLIENT){
    REAL endTime=tSysTimeFloat()+20;
    con << "Waiting for gamestate...\n";
    while (!sg_currentGame && tSysTimeFloat()<endTime){
      sn_Receive();
      nNetObject::SyncAll();
      usleep(sn_defaultDelay);
    }
    if (sg_currentGame){
      sr_con.autoDisplayAtNewline=false;
      sr_con.fullscreen=false;

      con << "Received! Syncing gamestate...\n";
      EnterGame();
    }
    else{
      //con << "Timeout. Try again!\n";
      sr_con.autoDisplayAtNewline=true;
      sr_con.fullscreen=true;
#ifndef DEDICATED
      sr_SwapGL();
      sr_SwapGL();
#endif
      usleep(4000000);
    }
  }
  else{
    //con << "Login denied. Server is probably full.\n";
    sr_con.autoDisplayAtNewline=true;
    sr_con.fullscreen=true;
#ifndef DEDICATED
    sr_SwapGL();
    sr_SwapGL();
#endif
    usleep(4000000);
  }

  sr_con.autoDisplayAtNewline=false;
  sr_con.fullscreen=false;

  sn_SetNetState(nSTANDALONE);

  sr_textOut=to;
}

static tConfItem<int> mor("MAX_OUT_RATE","maximum network output rate",sn_maxRateOut);
static tConfItem<int> mir("MAX_IN_RATE","maximum network output rate",sn_maxRateIn);


static tConfItem<int> pc("PING_CHARITY","how much ping are you willing to take over from your opponent?",pingCharity);


uMenu *in_game_menu=NULL;

void ret_to_MainMenu(){
  if (in_game_menu)
    in_game_menu->Exit();

  sr_con.fullscreen=true;
  sr_con.autoDisplayAtNewline=true;

  if(sg_currentGame)
    sg_currentGame->NoLongerGoOn();

  sn_SetNetState(nSTANDALONE);
}

void net_game(){
  uMenu net_menu("Network Game");

  uMenuItemFunction serv
    (&net_menu,"Host Network Game",
     "Enter the game grid! Other players are allowed to join you "
     "via the \"Connect to Server\"-menuitem.",&host_game);

  uMenuItemToggle po2
    (&net_menu,"Prediction",
     "In a network game, this extrapolates the cycles' movement. Leaving "
     "it disabled makes the graphics smoother, enabling it gives yo a better "
     "image of the actual situation. I leave it disabled; "
     "the Lag-O-Meter is a good substitute for prediction. This is always "
     "disabled in server mode.",
     sr_predictObjects);
  
  uMenuItemToggle lm2
    (&net_menu,"Lag-O-Meter",
     "In a network game, the place where the other players may already "
 "be now (but you have not yet noticed because of the network delay) "
     "is indicated as a geometrical shape. Useful for internet play.",
     sr_laggometer);


  uMenuItemInt p_s
    (&net_menu,"Ping Charity:",
     "The maximum ping (in ms) you are willing to take over from the "
     "other players. Armagetron will reduce their ping and increase yours, "
     "until you have equal ping or the maximum transfer set by this "
     "menuitem is hit.",
     pingCharity,0,300,20);

  uMenuItemInt out_rate
    (&net_menu,"Output Rate:",
     "The maximum number of kilobytes your network can send per second. "
     "Set it to two or three if you do not wish to act as a server; "
     "more bandwidth is never used.",
     sn_maxRateOut,1,20);
  

  uMenuItemInt in_rate
    (&net_menu,"Input Rate:",
     "The maximum number of kilobytes your network can receive per second. "
     "1 for 9.6k modems (only limited play possible), "
     "3 for 28.8k modems (usualy no problems)...7 for 56k modems, "
     "8 for ISDN, more for cable modems, (A)DSL and LAN.",
     sn_maxRateIn,1,20);
  


  uMenuItemString serverName
    (&net_menu,"Server Name:",
     "The name or IP adress of the server you wish to join",sn_serverName);
    
  uMenuItemFunction start(&net_menu,"Connect To Server",
				     "Enter the game grid!",&connect_to_server);


  net_menu.Enter();
}


static void StartNewMatch(){
  if (sg_currentGame)
    sg_currentGame->StartNewMatch();
  if (sn_GetNetState()!=nCLIENT){
    sn_CenterMessage("Reset");
    sn_ConsoleOut("Resetting scores and starting new match after this round.\n");
  }
}

static void StartNewMatch_conf(istream &){
  StartNewMatch();
}


static tConfItemFunc snm("START_NEW_MATCH","initiates a new match",&StartNewMatch_conf);

void MainMenu(bool ingame){
  if (ingame)
    sr_con.SetHeight(2);

  uMenu game_menu("Game Menu");

  uMenuItemFunction *reset=NULL;
  
  if(ingame && sn_GetNetState()!=nCLIENT){
    reset=new uMenuItemFunction
      (&game_menu,"Start New Match",
       "After the end of the current round, a new match is started "
       "and all scores are set back to 0.",
       &StartNewMatch);
  }

  uMenuItemSelection<gFinishType> finisht
    (&game_menu,"Finish Mode:",
     "What happens if all human players are dead?\n",sg_finishType);
  finisht.NewChoice("Express",
		   "Fastest possible game restart.",
		   gFINISH_EXPRESS);
  finisht.NewChoice("Stop",
		   "Abort the game immediately.",
		   gFINISH_IMMEDIATELY);
  finisht.NewChoice("Fast Finish",
		   "Let the game continue until all AIs are dead, but "
		   "in fast forward mode.",
		   gFINISH_SPEEDUP);
  finisht.NewChoice("Normal Finish",
		     "Let the game continue until all AIs are dead.",
		     gFINISH_NORMAL);

  uMenuItemSelection<gGameType> gamet
    (&game_menu,"Game Mode:",
     "Select the rules you want to play by:\n",sg_gameType);
  gamet.NewChoice("Freestyle",
		   "No rules, no winner. The game stops when all "
		   "human players are dead.",
		   gFREESTYLE);
  gamet.NewChoice("Last Man Standing",
		   "The last human alive wins. If all human players die, "
		   "the computer wins.",
		     gDUEL);
gamet.NewChoice("Humans vs. AI",
  "All humans form a team, the computer players the other. "
"The humans start from the same position in the arena. "
		   "If all the players from one team are deleted, the other "
		   "team wins.",
		   gHUMAN_VS_AI);
    
  uMenuItemToggle autoaiconf
    (&game_menu,"Auto AI:",
     "Automatically determine the number of AI opponents you are going to "
     "eFace next based on our current success.",
     auto_ai);

  uMenuItemInt aiconf
    (&game_menu,"AI Players:",
     "Lets you select the number of computer controlled players"
     "\n(\"Artificial Intelligence\") in the game.",
     ais,0,MAXAI);

  
  uMenuItemFunction *connect=NULL,*start=NULL,*sound=NULL;

  if (!ingame){
     connect=new uMenuItemFunction
      (&game_menu,"Network Game",
       "This joins or creates a network multiplayer game.",
       &net_game);
    
    start= new uMenuItemFunction(&game_menu,"Start Game",
				       "Enter the game grid!",&singlePlayer_game);
  }

  char *title;
  if (!ingame)
    title="Main Menu";
  else
    title="In-Game Menu";
    

  uMenu MainMenu(title,false);

  if (ingame)
    in_game_menu=&MainMenu;

  char *extitle,*exhelp;
  if (!ingame){
    extitle="Exit Game";
    exhelp="Goodbye!";
  }
  else{
    extitle="Return to Game";
    exhelp="Return to the game grid!";
  }

  uMenuItemExit exx(&MainMenu,extitle,
			       exhelp);


  uMenuItemFunction *return_to_main=NULL;

  if (ingame){
    if (sn_GetNetState()==nSTANDALONE)
      return_to_main=new uMenuItemFunction
	(&MainMenu,"Exit Game",
	 "Brings you back to the main menu.",
	 &ret_to_MainMenu);
    else if (sn_GetNetState()==nCLIENT)
      return_to_main=new uMenuItemFunction
	(&MainMenu,"Disconnect",
	 "Disconnects you from the network and brings you back to the "
	 "main menu.",
	 &ret_to_MainMenu);
    else 
      return_to_main=new uMenuItemFunction
	(&MainMenu,"Shutdown Server",
	 "Disconnects all clients (not nice if there are any...) "
	 "and brings you back to the "
	 "main menu.",
	 &ret_to_MainMenu);
  }
  

  uMenuItemSubmenu subm
    (&MainMenu,&sg_screenMenu,
     "Toggles features of your graphic system.");

  sound = new uMenuItemFunction
    (&MainMenu,"Sound Settings",
     "Sound quality settings.",&se_SoundMenu);

  
  uMenuItemFunction *se_PlayerMenu=NULL;

  //  if (!ingame)
  se_PlayerMenu= new uMenuItemFunction 
    (&MainMenu,"Player Menu",
     "Select player names and control methods.",
     &sg_PlayerMenu);
  
  uMenu misc("Misc Stuff");
  
  uMenuItemFunction global_key
    (&misc,"Global Keyboard Configuration",
     "Some keyboard settings independent of the current player.",
     &su_InputConfigGlobal);
   
  uMenuItemToggle wrap
    (&misc,"Menu Wrap",
     "What happens if you are at the top of the menu and press up?",
     uMenu::wrap);
  
  uMenuItemToggle to2
    (&misc,"Text Output",
     "Toggles the display of text messages (chat, status info..) on "
     "the screen. Forced on for network games.",sr_textOut);

  uMenuItemToggle fps2
    (&misc,"FPS Display",
     "Toggles the display of the current FPS (frames per secon) "
     "rate in the lower left corner.",sr_FPSOut);
  
  uMenuItemToggle mp
    (&misc,"Moviepack",
     "If this is enabled and the moviepack is installed, Armagetron "
     "will display more movie-like graphics.",sg_moviepackUse);


  uMenuItemSubmenu misc_sm
    (&MainMenu,&misc,
     "Diverse items that had no place elsewere, i.e. global keys.");


  char *gamehelp;
  if (!ingame)
    gamehelp="Game configuration and launch.";
  else
    gamehelp="Game configuration";
  
  uMenuItemSubmenu gm(&MainMenu,&game_menu,
				 "Game configuration and launch."
				 );


  if (!ingame)
    ePlayerNetID::Update();
  MainMenu.Enter();

  if (sound)
    delete sound;
  if (connect)
    delete connect;
  if (start)
    delete start;
  if (return_to_main)
    delete return_to_main;
  if (se_PlayerMenu)
    delete se_PlayerMenu;
  if (reset)
    delete reset;

  if (ingame)
    in_game_menu=NULL;

  if (ingame)
    sr_con.SetHeight(7);
}



// Game states:

#define GS_CREATED 0        // newborn baby
#define GS_CREATE_GRID      10       
#define GS_CREATE_OBJECTS   20
#define GS_TRANSFER_OBJECTS 30
#define GS_CAMERA           35
#define GS_SYNCING          40
#define GS_SYNCING2         41
#define GS_SYNCING3         42
#define GS_PLAY             50
#define GS_DELETE_OBJECTS   60
#define GS_DELETE_GRID      70

#ifndef DEDICATED
static void ingame_menu(){
  se_ChatState(true);
  if (sn_GetNetState()==nSTANDALONE)
    se_PauseGameTimer(true);
  MainMenu(true);
  if (sn_GetNetState()==nSTANDALONE)
    se_PauseGameTimer(false);
  se_ChatState(false);
  if ((bool(sg_currentGame) && sg_currentGame->GetState()!=GS_PLAY))
      //      || se_PlayerNetIDs.Len()==0)
    ePlayerNetID::Update();
}
#endif


static nNOInitialisator<gGame> game_init(20,"game");

nDescriptor &gGame::CreatorDescriptor() const{
  return game_init;
}


void gGame::Init(){
  state=stateNext=GS_CREATED;
  goon=true;

  sg_currentGame=this;
#ifdef DEBUG
  // con << "Game created.\n";
#endif
  StartNewMatchNow();
}


void gGame::NoLongerGoOn(){
  goon=false;
  stateNext=GS_DELETE_OBJECTS;
  if (sn_GetNetState()==nSERVER)
    RequestSync();
}

gGame::gGame(){
  if (sn_GetNetState()!=nCLIENT)
    RequestSync();
  Init();
}

gGame::gGame(nMessage &m):nNetObject(m){
  Init();
}


gGame::~gGame(){
#ifdef DEBUG
  //con << "deleting game...\n";
#endif
  //stateNext=GS_CREATE_GRID;
  //StateUpdate();
  if (sg_currentGame == this){
    AddRef();
    AddRef();
    sg_currentGame = NULL;
    refCtr--;
  }
}


void gGame::WriteSync(nMessage &m){
  nNetObject::WriteSync(m);
  m.Write(stateNext);
#ifdef DEBUG
  //con << "Wrote game state " << stateNext << ".\n";
#endif
}

void gGame::ReadSync(nMessage &m){
  nNetObject::ReadSync(m);
  m.Read(stateNext);
#ifdef DEBUG
  //con << "Read game state " << stateNext << ".\n";
#endif
}


void gGame::NetSync(){
#ifdef DEDICATED
  if (!sr_glOut && ePlayer::PlayerConfig(0)->cam)
    tERR_ERROR_INT("Someone messed with the camera!");
#endif
  nNetObject::SyncAll();
  sn_Receive();
}
void gGame::NetSyncIdle(){
  NetSync();
  usleep(sn_defaultDelay);
}


unsigned short client_gamestate[MAXCLIENTS+2];

static void client_gamestate_handler(nMessage &m){
  m.Read(client_gamestate[m.SenderID()]);
  //#ifdef DEBUG
  //con << "User " << m.SenderID() << " is in Mode " 
  //<< client_gamestate[m.SenderID()] << '\n';
  //#endif
}

static nDescriptor client_gs(21,client_gamestate_handler,"client_gamestate");



void gGame::SyncState(unsigned short state){
  if (sn_GetNetState()==nSERVER){

    bool firsttime=true;
    bool goon=true;
    REAL timeout=tSysTimeFloat()+5;

    //sn_Sync(5,true);
    NetSyncIdle();

    while(goon && tSysTimeFloat()<timeout){
      /*
      if (sg_currentGame)
	sg_currentGame->RequestSync();
      */

      //sn_Sync(5,true);
      NetSyncIdle();

      goon=false;
      for(int i=MAXCLIENTS;i>0;i--)
	if (sn_sockets[i]>0 && client_gamestate[i]!=state)
	  goon=true;
      if (goon && firsttime){
	firsttime=false;
#ifdef DEBUG
	con << "Waiting for users to enter gamestate " << state << '\n';
	if (sn_ackPending[1]>2)
	  con << "Ack_pending=" << sn_ackPending[1] << ".\n";
#endif	  
      }
    }
  }
}


void gGame::SetState(unsigned short act,unsigned short next){
  state=act;
#ifdef DEBUG
  //con << "Entering gamestate " << state 
  //<< ", next state: " << next << '\n';
#endif

  if (sn_GetNetState()==nSERVER){
    RequestSync();
    NetSyncIdle();
    SyncState(state);
  }

  if (stateNext!=next){
    if (sn_GetNetState()!=nCLIENT || goon==false){

      stateNext=next;

      if (sn_GetNetState()==nSERVER){
	RequestSync();
	NetSyncIdle();
      }
    }
  }
}

// from nNetwork.C
extern REAL planned_rate_control[MAXCLIENTS+2];
extern REAL sent_per_messid[100];

void gGame::StateUpdate(){
  if (state==GS_CREATED)
    stateNext=GS_PLAY;
  
  while (stateNext!=state){
    switch(state){
    case GS_CREATED:
    case GS_CREATE_GRID:

#ifdef DEBUG      
      /*
      con << "Message stats:\n";
      for(int i=0;i<40;i++){
	con << i << ":" << sent_per_messid[i] << '\n';
	sent_per_messid[i]=0;
      }
      */
#endif      

      // transfer game settings
      nConfItemBase::s_SendConfig();
      ePlayerNetID::Update();
      
      con << "Creating grid...\n";
      init_game_grid();
      
      SetState(GS_CREATE_OBJECTS,GS_TRANSFER_OBJECTS);
      break;
    case GS_CREATE_OBJECTS:
      // con << "Creating objects...\n";

      if (sn_GetNetState()!=nCLIENT){
	bool newsg_singlePlayer=(se_PlayerNetIDs.Len()<=1);
	if (sg_singlePlayer != newsg_singlePlayer)
	  StartNewMatch();
	sg_singlePlayer=newsg_singlePlayer;
      }

#ifdef DEDICATED
      if (sg_singlePlayer){
	this_score_win=sp_score_win;
	limitTimeThis=sp_limitTime;
	this_limit_rounds=sp_limit_rounds;
	this_limit_score=sp_limit_score;
	this_ais=sp_ais;
      }
      else
#endif
	{
	  this_score_win=score_win;
	  limitTimeThis=limitTime;
	  this_limit_rounds=limit_rounds;
	  this_limit_score=limit_score;
	  this_ais=ais;
	}

      se_ResetGameTimer();
      se_PauseGameTimer(true);
      init_game_objects();
      SetState(GS_TRANSFER_OBJECTS,GS_CAMERA);

      if (sn_GetNetState() == nCLIENT && just_connected){
	sn_Sync(5,true);
	sn_Sync(5,true);
      }
      just_connected=false;

      break;
    case GS_TRANSFER_OBJECTS:
      // con << "Transferring objects...\n";
      rTexture::LoadAll();
      se_ResetGameTimer();
      se_PauseGameTimer(true);


      // push all data
      if(sn_GetNetState()==nSERVER){
	bool goon=true;
	double timeout=tSysTimeFloat()+20;
	while(goon && tSysTimeFloat()<timeout){
	  NetSyncIdle();
	  goon=false;
	  for(int i=MAXCLIENTS;i>0;i--)
	    if (sn_sockets[i]>0)
	      for(int j=sn_netObjects.Len()-1;j>=0;j--)
		if (sn_netObjects(j) && 
		    !sn_netObjects(j)->HasBeenTransmitted(i) &&
		    sn_netObjects(j)->syncRequested(i))
		  goon=true;
	}
	if (tSysTimeFloat()<timeout)
	  con << "done!\n";
	else{
	  con << "\n\ntimeout! Reason:\n";
	  for(int i=MAXCLIENTS;i>0;i--)
	    if (sn_sockets[i]>0)
	      for(int j=sn_netObjects.Len()-1;j>=0;j--)
		if (sn_netObjects(j) && !sn_netObjects(j)->HasBeenTransmitted(i))
		  con << "User " << i << " does not know about nNetObject "
		      << j << '\n';
	  con << "\n\n\n";
	}
      }

      SetState(GS_CAMERA,GS_SYNCING);
      break;
    case GS_CAMERA:
      // con << "Setting camera position...\n";
      rTexture::LoadAll();
      se_ResetGameTimer(-PREPARE_TIME);
      se_PauseGameTimer(true);
      init_game_camera();
      SetState(GS_SYNCING,GS_PLAY);
      break;
    case GS_SYNCING:
      // con << "Syncing timer...\n";
      rTexture::LoadAll();
      SetState(GS_PLAY,GS_PLAY);
      if (sn_GetNetState()!=nCLIENT){
	tString mess;
	if (rounds<=0){
	  sn_ConsoleOut("Resetting scores...\n");
	  StartNewMatchNow();
	  sn_CenterMessage("New Match");
	  se_SaveToScoreFile("New Match\n");
	}
	mess << "go (round " << rounds+1 << " of " << this_limit_rounds << ")!\n";
	se_SaveToScoreFile("New Round\n");
	sn_ConsoleOut(mess);
      }
      //con << ePlayerNetID::Ranking();

      se_PauseGameTimer(false);
      se_SyncGameTimer();
      sr_con.fullscreen=false;
      sr_con.autoDisplayAtNewline=false;
      break;
    case GS_PLAY:
#ifdef DEDICATED
      {
	if (se_PlayerNetIDs.Len()==0)
	  goon = 0;

	Analysis(0);

	{
	  ifstream s("everytime.cfg");
	  if (s)
	    tConfItemBase::LoadAll(s);
	}
	
	// safe current players in a file
	cp();
      }	
#endif






      se_UserShowScores(false);
      //con.autoDisplayAtNewline=true;
      sr_con.fullscreen=true;
      SetState(GS_DELETE_OBJECTS,GS_DELETE_GRID);
      break;
    case GS_DELETE_OBJECTS:
      gHighscoresBase::SaveAll();
      con << "Deleting objects...\n";
      exit_game_objects();
      SetState(GS_DELETE_GRID,GS_CREATE_GRID);
      break;
    case GS_DELETE_GRID:
      con << "Deleting grid...\n";
      exit_game_objects();
      if (goon)
	SetState(GS_CREATE_GRID,GS_CREATE_OBJECTS);
      else
	state=GS_CREATE_GRID;
      break;
    default:
      break;
    }
    if (sn_GetNetState()==nSERVER){
      NetSyncIdle();
      RequestSync();
      NetSyncIdle();
    }
    else if (sn_GetNetState()==nCLIENT){ // inform the server of our progress
      NetSyncIdle();
      nMessage *m=new nMessage(client_gs);
      m->Write(state);
      m->Send(0);
#ifdef DEBUG
      //      con << "sending gamestate " << state << '\n';
#endif
      NetSyncIdle();
    }
  }
}

void gGame::Timestep(REAL time,bool cam){
#ifdef DEBUG
  tMemMan::Check();
  #define MINTS 50.0
#else
  #define MINTS 1
#endif

  for(REAL t=lastTimeTimestep+MINTS;t<time;t+=MINTS)
    s_Timestep(t,cam);

  if (time>lastTimeTimestep)
    s_Timestep(time,cam);
}


void gGame::Analysis(REAL time){
  static REAL wintimer=0;
  static REAL lastdeath=0;

  // send timeout warnings


  if (tSysTimeFloat()-startTime>10){
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<10 && warning<6){
      sn_CenterMessage("Ten seconds left!\n");
      sn_ConsoleOut("Ten seconds left!\n");
      warning=6;
    }
    
    
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<30 && warning<5){
      sn_CenterMessage("30 seconds left!\n");
      sn_ConsoleOut("30 seconds left!\n");
      warning=5;
    }
    
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<60 && warning<4){
      sn_CenterMessage("One minute left!\n");
      sn_ConsoleOut("One minute left!\n");
      warning=4;
    }
    
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<2*60 && warning<3){
      sn_ConsoleOut("Two minutes left!\n");
      warning=3;
    }
    
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<5*60 && warning<2){
      sn_ConsoleOut("Five minutes left!\n");
      warning=2;
    }
    
    if ((startTime+limitTimeThis*60)-tSysTimeFloat()<10*60 && warning<1){
      sn_ConsoleOut("Ten minutes left!\n");
      warning=1;
    }
  }


  // analyze the ranking list
  if (absolute_winner==0 && (winner==0 || wintimer<time-.3) && 
       sn_GetNetState()!=nCLIENT && se_PlayerNetIDs.Len()){
    ePlayerNetID::SortByScore();
    if (se_PlayerNetIDs.Len()==1 
	|| se_PlayerNetIDs(0)->Score()>se_PlayerNetIDs(1)->Score()){
      // only then we can have a true winner
      if (se_PlayerNetIDs(0)->Score() >=this_limit_score || rounds>=this_limit_rounds
	  || tSysTimeFloat()>=startTime+limitTimeThis*60){
	tString message;
	message << "Champ: ";
	message << se_PlayerNetIDs[0]->name;
	sn_CenterMessage(message);
	message.Clear();
	message << "Overall Winner: ";
	message << *se_PlayerNetIDs[0];
	message << ColorString(1,1,1);
	if (se_PlayerNetIDs(0)->Score() >=this_limit_score)
	  message << " hit the score limit(" 
		  << se_PlayerNetIDs(0)->Score() <<  '/'
		  << this_limit_score << ").\n";
	else if ( tSysTimeFloat()>=startTime+limitTimeThis*60)
	  message << " after the timelimit of " << limitTimeThis
		  << " minutes was hit.\n";
	else
	  message << " after " << rounds << " rounds.\n";

	se_SaveToScoreFile(message);
	se_SaveToScoreFile("Final Scores:\n");
	se_SaveToScoreFile(ePlayerNetID::Ranking());
	se_SaveToScoreFile("\n\n");

	if (!sg_singlePlayer)
	  highscore_won_matches.Add(se_PlayerNetIDs(0)->name,1);
	
	sn_ConsoleOut(message);
	wintimer=time;
	absolute_winner=winner=1;

	StartNewMatch();
      }
    }
  }

  
  int alive=0;
  int last_alive=-1;
  REAL deathTime=0;
  
  for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--){
    gCycle *g=(gCycle *)se_PlayerNetIDs(i)->Object();
    if(g){
      if(g->Alive()){
	alive++;
	last_alive=i;
      }
      else{
	REAL dt=g->DeathTime();
	if (dt>deathTime)
	  deathTime=dt;
      }
    }
  }
  
  int ai_alive=0;
  
  for(int j=this_ais-1;j>=0;j--)
    if(ai[j] && ai[j]->Alive())
      ai_alive++;

  static int all_alive_last=0;
  if (ai_alive+alive!=all_alive_last){
    all_alive_last=ai_alive+alive;
    lastdeath=time;
  }

  // who is alive?
  if (winner==0){
    if(ai_alive==0 && (sn_GetNetState()!=nCLIENT || se_PlayerNetIDs.Len()>1)){
      if ((this_ais || se_PlayerNetIDs.Len()>1) && alive<=1 && sg_gameType==gDUEL){
	winner=last_alive+1;
	wintimer=time;
      }
      if (this_ais && sg_gameType==gHUMAN_VS_AI){
	winner=1;
	wintimer=time;
      }
    }
    if(alive==0 && se_PlayerNetIDs.Len()>0){
      if (sg_gameType!=gFREESTYLE)
	winner=-1;
      wintimer=time;
    }
    
    if (winner==0 && alive==0 && ai_alive==0){
      // emergency
      winner=-1;
      wintimer=time;
    }

    if (winner){
      rounds++;
      tString message;
      message << "Winner : ";
      if (winner<0){
 	AutoAI(false);
	message << "AI.";
      }
      else{
	if (sg_gameType==gHUMAN_VS_AI){
	  AutoAI(true);
	  message << "Humans.";
	}
	else{
	  AutoAI(true);
	  message << se_PlayerNetIDs[winner-1]->name;
	  se_PlayerNetIDs[winner-1]->AddScore
	    (this_score_win,"for being last active program.");
	  if (!sg_singlePlayer)
	    highscore_won_rounds.Add(se_PlayerNetIDs[winner-1]->name,1);
	  highscore_ladder.winner(winner-1);
	}
      }
      sn_CenterMessage(message);
      message << '\n';
      se_SaveToScoreFile(message);
      check_hs();
    }
  }

  REAL fintime=6;
  
  if (sg_finishType==gFINISH_EXPRESS)
    fintime=2.5;

  if((winner && wintimer+fintime < time) 
     || (((alive==0 && se_PlayerNetIDs.Len()>=
#ifndef DEDICATED
	   1
#else
	   0
#endif
	   )) && time-deathTime >fintime-2)){
#ifdef DEBUG
  //con << "winner=" << winner << ' ';
  //con << "wintimer=" << wintimer << ' ';
  //con << "time=" << time << ' ';
  //con << "dt=" << deathTime << '\n';
#endif
    if (sg_finishType==gFINISH_IMMEDIATELY || sg_finishType==gFINISH_EXPRESS || 
	(ai_alive == 0 && alive == 1) || (alive+ai_alive==0 && time-lastdeath>4))
      SetState(GS_PLAY,GS_DELETE_OBJECTS);

    if (sg_finishType==gFINISH_SPEEDUP && se_mainGameTimer){
      se_mainGameTimer->speed*=1.01;
      if(se_mainGameTimer->speed>4)
	se_mainGameTimer->speed=4;
    }

}

  for(int k=this_ais-1;k>=0;k--)
    if (think && ai[k]) ai[k]->Timestep(time);
}  


void gGame::StartNewMatch(){
  check_hs();
  ePlayerNetID::ResetScore();
  rounds=-1;
}

void gGame::StartNewMatchNow(){
  ePlayerNetID::ResetScore();
  rounds=0;
  warning=0;
  startTime=tSysTimeFloat()-10;
}

#ifdef DEBUG	      
extern bool debug_grid;
// from display.cpp
bool simplify_grid=1;
#endif


bool gGame::GameLoop(bool input){
#ifdef DEDICATED
  usleep(10000);
#endif
  
#ifdef DEBUG
  se_CheckGrid();
  if (simplify_grid)
#endif
    eEdge::SimplifyAll(10);

#ifdef DEBUG
  se_CheckGrid();
#endif

  //if (cin.good() && !cin.underflow())
  //tConfItemBase::LoadAll(cin);
  // network syncing
  REAL gtime=0;
  REAL time=0;
  if (state==GS_PLAY){
    NetSync();
    se_SyncGameTimer();
    gtime=se_GameTime();
    time=gtime;

    if (sn_GetNetState()==nSTANDALONE && in_game_menu)
      se_PauseGameTimer(true);
    
    static int lastcountdown=0;
    int cd=int(floor(-time))+1;
    if (cd>=0 && cd<PREPARE_TIME && cd!=lastcountdown){
      lastcountdown=cd;
      tString s;
      s << cd;
      con.CenterDisplay(s,0);
    }
  }
    //con << sg_netPlayerWalls.Len() << '\n';

#ifndef DEDICATED
  if (input){
    static bool paused=false;
    
    SDL_Event tEvent;
    
    while(se_GetSDLInput(tEvent,time)){
      if (time>gtime) time=gtime;
      if(time>lastTime_gameloop){
	Timestep(time);
	lastTime_gameloop=time;
      }


      if (!su_HandleEvent(tEvent))
	switch (tEvent.type){
	case SDL_MOUSEBUTTONDOWN:
	  break;
	case SDL_KEYDOWN:
	  switch (tEvent.key.keysym.sym){
	    
	  case(27):
	  case('q'):
	    st_ToDo(&ingame_menu);
	    break;
	    
	  case('p'):
	    paused=!paused;
	    se_PauseGameTimer(paused);
	    break; 
	  case('r'):
	    rTexture::UnloadAll();
	    break;
#ifdef POWERPAK_DEB
	  case('d'):
	    pp_out=!pp_out;
	    break;
#endif
	  case('g'):
	    su_mouseGrab=!su_mouseGrab;
	    break;
	    
#ifdef DEBUG	      
	  case('d'):
      	    debug_grid=!debug_grid;
	    break;

	  case('a'):
	    simplify_grid=!simplify_grid;
	    break;

	  case('l'):
	    sr_glOut=!sr_glOut;
	    break;
	    
	  case('t'):
	    think=!think;
	    break;
	    /* #ifndef WIN32
	    case('f'):
	      fullscreen=(!fullscreen);
	      con << fullscreen << "x!\n";
	      XMesaSetFXmode(fullscreen ? XMESA_FX_FULLSCREEN : XMESA_FX_WINDOW);
	      break;        
	      #endif */
#endif
	      
	  default:
	    break;
	  }
	  break;
	  
	default:
	  break;
	}
    }
    
    su_InputSync();
  }
#endif
  
  
  NetSync();
  
  if (state==GS_PLAY){
    if (gtime<0 && gtime>-PREPARE_TIME+.3)
      eCamera::s_Timestep(gtime);
    else{
      if (gtime>=lastTime_gameloop){
	Timestep(gtime,true);
	lastTime_gameloop=gtime;
      }
      lastTime_gameloop=gtime;
    }
    //    else if (lastTime_gameloop>gtime+10)
    // lastTime_gameloop=gtime;
    

    
    if (sn_GetNetState()!=nCLIENT)
      Analysis(gtime);
  
    if (sr_glOut && gtime>-PREPARE_TIME+.5 && goon)
      Render(gtime,input);
    else{
#ifndef DEDICATED
      if (sr_glOut && input){
        sr_ClearGL();
	    sr_SwapGL();
      }
#endif

      usleep(10000);
    }

    return true;
  }
  else{
#ifndef DEDICATED
    if (sr_glOut && input){
        sr_ClearGL();
		sr_SwapGL();
    }
#endif
    NetSyncIdle();
    return goon || state!=GS_CREATE_GRID;
  }
}


bool gGame::GridIsReady(int client){
  return HasBeenTransmitted(client) && 
    (client_gamestate[client]==GS_TRANSFER_OBJECTS ||
     client_gamestate[client]==GS_PLAY ||
     client_gamestate[client]==GS_DELETE_OBJECTS);
}

#include <fcntl.h> 
#include <stdio.h> 
#include <errno.h> 

bool GameLoop(bool input=true){
  /*
  int oldflags = fcntl (fileno(stdin), F_GETFD, 0);
  if (oldflags<0)
    cout << errno << '\n';
    
  if (fcntl(fileno(stdin), F_SETFL, oldflags | O_NONBLOCK)<0)
    cout << errno << '\n';
   
 //if (cin && cin.good() && !cin.eof() && !cin.fail() && !cin.bad()){
 //if (cin.rdbuf()->overflow()!=EOF){
 //if (cin.rdbuf()->in_avail()>0){
 
  char c[10];
  int in=0;
  in=read (fileno(stdin),c,9);
  for (int i=0;i<in;i++)
    cout << c;
  */

  // see if pings have dramatically changed
  if(sn_GetNetState()==nSERVER){
    REAL t=tSysTimeFloat();
    for(int i=se_PlayerNetIDs.Len()-1;i>=0;i--){
      ePlayerNetID *p=se_PlayerNetIDs(i);
      if (fabs((t - p->lastSync)*(sn_ping[p->Owner()] - p->ping))>1){
	// if yes, send a message about it
	p->ping=sn_ping[p->Owner()];
	p->RequestSync(false);
      }
    }
  }

  bool goon=false;
  if(sg_currentGame){
    sg_currentGame->AddRef();
    sg_currentGame->StateUpdate();
    goon=!uMenu::quickexit && bool(sg_currentGame) && sg_currentGame->GameLoop(input);
    if (sg_currentGame) sg_currentGame->Release();
  }
  return goon;
}

void gameloop_idle(){
  GameLoop(false);
}

static eSoundPlayer introPlayer(intro);
static eSoundPlayer extroPlayer(extro);

void EnterGame(){
  nNetState enter_state=sn_GetNetState();

  sr_con.SetHeight(7);

  extroPlayer.End();
  introPlayer.MakeGlobal();
  introPlayer.Reset();

  exit_game_objects();

  uMenu::SetIdle(gameloop_idle);
  sr_con.autoDisplayAtSwap=true;
  bool goon=true;
  while (bool(sg_currentGame) && goon && sn_GetNetState()==enter_state){
#ifdef DEDICATED // read input
    sr_Read_stdin();
#endif
    goon=GameLoop();
    st_DoToDo();
  }

  extroPlayer.MakeGlobal();
  extroPlayer.Reset();

  uMenu::SetIdle(NULL);
  sr_con.autoDisplayAtSwap=false;

  exit_game_objects();
  nNetObject::ClearAll();
  ePlayerNetID::CompleteRebuild();
  sg_currentGame = NULL;
}


bool GridIsReady(int c){
  return bool(sg_currentGame) && sg_currentGame->GridIsReady(c);
}


// avoid transfer of game objects if the grid is not yes constructed
static bool notrans(){
  return !GridIsReady(eTransferInhibitor::User());
}

static eTransferInhibitor inh(&notrans);

// are we active?
void Activate(bool act){
  sr_glOut=act;
  
  se_SoundPause(!act);
  
  if (sn_GetNetState()==nSTANDALONE)
    se_PauseGameTimer(!act);
  
  se_ChatState(!act);
}


static void LoginCallback(){
  client_gamestate[nCallbackLoginLogout::User()]=0;
}

static nCallbackLoginLogout lc(LoginCallback);
