/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)
#include <stdio.h>
#include <stdlib.h> 
**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_gWALL_H
#define ArmageTron_gWALL_H

#include "eAdvWall.h"
#include "nNetObject.h"
class gCycle;

class gWallRim:public eWallRim{
public:
  gWallRim(bool backface_cull=true,REAL h=10000000);
  virtual ~gWallRim();
  
  virtual bool Splittable() const;

  virtual void Split(eWall *& w1,eWall *& w2,REAL a);

#ifndef DEDICATED
  void RenderReal();
#endif
};


class gPlayerWall:public eWall{
  tCONTROLLED_PTR(gCycle) cycle;
  REAL startTime,endTime;
  REAL startPos,endPos;
  
  unsigned int displayList;
#ifndef DEDICATED
  virtual void RenderNormal(eCoord &x1,eCoord &x2,REAL ta,REAL te,REAL r,REAL g,REAL b,REAL a);
  virtual void RenderBegin(eCoord &x1,eCoord &x2,REAL ta,REAL te,REAL ra,REAL rb,REAL r,REAL g,REAL b,REAL a);
#endif
public:
  gPlayerWall(gCycle *p,REAL st,REAL et,REAL sp,REAL ep);
  virtual ~gPlayerWall();

  //  virtual ArmageTron_eWalltype type();

  virtual void Flip();
  
  virtual bool Splittable() const;
  virtual bool Deletable() const;

  virtual void Split(eWall *& w1,eWall *& w2,REAL a);

#ifndef DEDICATED
  virtual void Render();
  void RenderList(bool list);
#endif

  virtual REAL BlockHeight() const;
  virtual REAL SeeHeight() const;

  void SetEndTime(REAL et);
  void SetEndPos(REAL ep);

  REAL Time(REAL a) const;
  REAL Pos(REAL a) const{return startPos + a*(endPos-startPos);}

  gCycle *Cylce();
};


// the sn_netObjects that represents eWalls across the network.
class gNetPlayerWall: public nNetObject{
  friend class gCycle;
  int id,griddedid;         

  tCONTROLLED_PTR(gCycle) c;       // our cycle
  tCHECKED_PTR(eEdge)  e;       // the eEdge we are representing
  // tCHECKED_PTR(gPlayerWall) w; // and the eWall.
  eCoord dir;      // the direction from start to end
  REAL dbegin;    // the start position
  eCoord beg,end;  // start and end points
  REAL tBeg,tEnd; // start and end time
  
  unsigned short inGrid;   // are we planned to be insite the grid?
  REAL           gridding; // when are we going to enter the grid?

  bool           preliminary; // is it a eWall preliminary installed
  // by the client while it is waiting for the real eWall from the server?

  void MyInitAfterCreation();
  void real_CopyIntoGrid();
public:
  virtual void InitAfterCreation();
  gNetPlayerWall(gCycle *c,
		  const eCoord &beg,const eCoord &dir,
		  REAL tBeg, REAL dbeg);

  void Update(REAL tEnd,REAL dend);
  void Update(REAL tEnd,const eCoord &pend);
  void CopyIntoGrid(bool force=false);
  static void s_CopyIntoGrid();

  gNetPlayerWall(nMessage &m);

  //eCoord Vec(){return w->Vec();}
  eCoord Vec(){return e->Vec();}
protected:
  virtual ~gNetPlayerWall();
public:
  virtual bool ActionOnQuit();

  virtual bool ClearToTransmit(int user) const;

  virtual void WriteSync(nMessage &m);
  virtual void ReadSync(nMessage &m);

  virtual void WriteCreate(nMessage &m);
  virtual nDescriptor &CreatorDescriptor() const;

 virtual bool SyncIsNew(nMessage &m);


  eEdge *Edge(){return e;}
  gPlayerWall *Wall(){if (e) return (gPlayerWall *)e->Wall(); else return NULL;}
  gCycle *Cycle(){return c;}

  bool Preliminary(){return preliminary;}

  static void Clear(); // delete all sg_netPlayerWalls.
};

extern List<gNetPlayerWall> sg_netPlayerWalls;

#endif
