/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "uInputQueue.h"
#include "rScreen.h"
#include "tConfiguration.h"
#include <iostream.h>

#ifndef DEDICATED
#include <SDL.h>
#endif

static su_TimerCallback *timer=NULL;

su_TimerCallback::su_TimerCallback(){
  timer = this;
}

su_TimerCallback::~su_TimerCallback(){
  if (timer == this)
    timer = NULL;
}

static inline REAL Time(){
  if (timer)
    return timer->GetTime();
  else
    return 0;
}

bool su_prefetchInput=false;
bool su_contInput=true;

#define MAX_PENDING_INPUT 100

static REAL times[MAX_PENDING_INPUT];
static SDL_Event tEvents[MAX_PENDING_INPUT];

static int   currentIn=0,current_out=0,next_in=1;


inline void increase(int &i){
  i++;
  if (i>=MAX_PENDING_INPUT)
    i=0;
}


static bool input_get=false;

void se_FetchAndStoreSDLInput(){
  #ifndef DEDICATED
  #ifndef WIN32
  SDL_PumpEvents();
  #endif
  #endif
}


bool se_StoreSDLEvent(const SDL_Event &tEvent){
 #ifndef WIN32
 if (next_in!=current_out && !input_get){
    //con << "Extra input!\n";
    tEvents[currentIn]=tEvent;
    times[currentIn]=Time();
    increase(currentIn);
    next_in=currentIn;
    increase(next_in);
    return false;
  }
  #endif
  return true;
}


bool se_GetSDLInput(SDL_Event &tEvent,REAL &time){
  bool ret;

  sr_LockSDL();
  input_get=true;
  if (current_out!=currentIn){
    time=times[current_out];
    tEvent=tEvents[current_out];
    increase(current_out);
    sr_UnlockSDL();
    input_get=false;
    ret=true;
  }
  else{

    time=Time();
    //    time=ArmageTronTimer;

    ret=
#ifndef DEDICATED
      SDL_PollEvent(&tEvent);
#else
    false;
#endif

    sr_UnlockSDL();
    input_get=false;
  }
  return ret;
}

int su_InputThread(void *){
  while (su_contInput){
    if (sr_screen && su_prefetchInput){
      sr_LockSDL();
#ifndef DEDICATED
      SDL_PumpEvents();
#endif
      sr_UnlockSDL();
    }
#ifndef WIN32
    usleep(100000);
#endif
  }
  return 0;
}



